/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.topics;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.topics.InternalNotificationEvent;
import com.pushtechnology.diffusion.command.commands.control.topics.TopicDescendantEvent;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="topic-descendant-event", valueType=TopicDescendantEvent.class)
public final class TopicDescendantEventSerialiser
extends AbstractSerialiser<TopicDescendantEvent> {
    private final ConversationIdSerialiser conversationIdSerialiser;

    public TopicDescendantEventSerialiser(ConversationIdSerialiser conversationIdSerialiser) {
        this.conversationIdSerialiser = conversationIdSerialiser;
    }

    @Override
    public void write(OutputStream out, TopicDescendantEvent value) throws IOException {
        this.conversationIdSerialiser.write(out, value.getCid());
        EncodedDataCodec.writeString(out, value.getTopicPath());
        EncodedDataCodec.writeByte(out, InternalNotificationEvent.TYPE_CONVERTER.toByte(value.getEventType()));
    }

    @Override
    protected TopicDescendantEvent readUnchecked(InputStream in) throws IOException {
        return new TopicDescendantEvent((ConversationId)this.conversationIdSerialiser.read(in), EncodedDataCodec.readString(in), InternalNotificationEvent.TYPE_CONVERTER.fromByte(EncodedDataCodec.readByte(in)));
    }
}

