/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.topics;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.topics.MissingTopicRequest;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import com.pushtechnology.diffusion.session.impl.SessionIdImpl;
import com.pushtechnology.diffusion.session.impl.SessionIdSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="missing-topic-request", valueType=MissingTopicRequest.class)
public final class MissingTopicRequestSerialiser
extends AbstractSerialiser<MissingTopicRequest> {
    private final SessionIdSerialiser sessionIdSerialiser;
    private final ConversationIdSerialiser conversationIDSerialiser;

    public MissingTopicRequestSerialiser(SessionIdSerialiser sessionIdSerialiser, ConversationIdSerialiser conversationIdSerialiser) {
        this.sessionIdSerialiser = sessionIdSerialiser;
        this.conversationIDSerialiser = conversationIdSerialiser;
    }

    @Override
    public MissingTopicRequest readUnchecked(InputStream in) throws IOException {
        InternalSessionId sessionId = (InternalSessionId)this.sessionIdSerialiser.read(in);
        String selectorExpression = EncodedDataCodec.readString(in);
        ConversationId cid = (ConversationId)this.conversationIDSerialiser.read(in);
        return new MissingTopicRequest(selectorExpression, Collections.singletonMap("$SessionId", sessionId.toString()), Collections.emptyList(), cid);
    }

    @Override
    public void write(OutputStream out, MissingTopicRequest request) throws IOException {
        InternalSessionId sessionId = SessionIdImpl.parseString(request.getSessionProperties().get("$SessionId"));
        this.sessionIdSerialiser.write(out, sessionId);
        EncodedDataCodec.writeString(out, request.getSelector());
        this.conversationIDSerialiser.write(out, request.getContext());
    }
}

