/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.client.AbstractSessionIdRequestSerialiser;
import com.pushtechnology.diffusion.command.commands.control.client.SetSessionPropertiesRequest;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import com.pushtechnology.diffusion.session.impl.SessionIdSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="set-session-properties-request", valueType=SetSessionPropertiesRequest.class)
public final class SetSessionPropertiesRequestSerialiser
extends AbstractSessionIdRequestSerialiser<SetSessionPropertiesRequest> {
    public SetSessionPropertiesRequestSerialiser(SessionIdSerialiser sessionIdSerialiser) {
        super(sessionIdSerialiser);
    }

    @Override
    protected void completeWrite(OutputStream out, SetSessionPropertiesRequest request) throws IOException {
        if (request.getOverwriteProperties().isEmpty()) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            SetSessionPropertiesRequestSerialiser.writeStringMap(out, request.getOverwriteProperties());
        }
        if (request.getRemoveProperties().isEmpty()) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            SetSessionPropertiesRequestSerialiser.writeStrings(out, request.getRemoveProperties());
        }
    }

    @Override
    protected SetSessionPropertiesRequest completeRead(InputStream in, InternalSessionId sessionId) throws IOException {
        List<String> remove;
        Map<String, String> overwrite;
        byte mapOption = EncodedDataCodec.readByte(in);
        if (mapOption == 1) {
            overwrite = SetSessionPropertiesRequestSerialiser.readStringMap(in);
        } else if (mapOption == 0) {
            overwrite = Collections.emptyMap();
        } else {
            throw new IOException("Invalid map option byte ");
        }
        byte listOption = EncodedDataCodec.readByte(in);
        if (listOption == 1) {
            remove = SetSessionPropertiesRequestSerialiser.readStrings(in);
        } else if (listOption == 0) {
            remove = Collections.emptyList();
        } else {
            throw new IOException("Invalid list option byte ");
        }
        return new SetSessionPropertiesRequest(sessionId, overwrite, remove);
    }
}

