/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.client.SessionPropertiesListenerRegistrationRequest;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

@CommandSerialiser(spec="session-properties-listener-registration-request", valueType=SessionPropertiesListenerRegistrationRequest.class)
public final class SessionPropertiesListenerRegistrationRequestSerialiser
extends AbstractSerialiser<SessionPropertiesListenerRegistrationRequest> {
    private final ConversationIdSerialiser theConversationIdSerialiser;

    public SessionPropertiesListenerRegistrationRequestSerialiser(ConversationIdSerialiser conversationIdSerialiser) {
        this.theConversationIdSerialiser = conversationIdSerialiser;
    }

    @Override
    public void write(OutputStream out, SessionPropertiesListenerRegistrationRequest request) throws IOException {
        Set<String> requestedProperties = request.getRequestedProperties();
        if (requestedProperties == null) {
            EncodedDataCodec.writeByte(out, (byte)1);
        } else {
            EncodedDataCodec.writeByte(out, (byte)0);
            SessionPropertiesListenerRegistrationRequestSerialiser.writeStrings(out, requestedProperties);
        }
        this.theConversationIdSerialiser.write(out, request.getConversationId());
    }

    @Override
    protected SessionPropertiesListenerRegistrationRequest readUnchecked(InputStream in) throws IOException {
        byte option = EncodedDataCodec.readByte(in);
        if (option == 0) {
            return SessionPropertiesListenerRegistrationRequest.createRegistrationRequest(SessionPropertiesListenerRegistrationRequestSerialiser.readCollection(in, HashSet::new, EncodedDataCodec::readString), (ConversationId)this.theConversationIdSerialiser.read(in));
        }
        if (option == 1) {
            return SessionPropertiesListenerRegistrationRequest.createDeregistrationRequest((ConversationId)this.theConversationIdSerialiser.read(in));
        }
        throw new IOException("Invalid option byte " + option);
    }
}

