/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.journal.Journable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class SessionPropertiesListenerRegistrationRequest
implements Journable {
    private final Set<String> theRequestedProperties;
    private final ConversationId theConversationId;

    public static SessionPropertiesListenerRegistrationRequest createRegistrationRequest(Set<String> requestedProperties, ConversationId conversationId) {
        return new SessionPropertiesListenerRegistrationRequest(Collections.unmodifiableSet(requestedProperties), conversationId);
    }

    public static SessionPropertiesListenerRegistrationRequest createDeregistrationRequest(ConversationId conversationId) {
        return new SessionPropertiesListenerRegistrationRequest(null, conversationId);
    }

    private SessionPropertiesListenerRegistrationRequest(Set<String> requestedProperties, ConversationId conversationId) {
        this.theRequestedProperties = requestedProperties;
        this.theConversationId = conversationId;
    }

    public Set<String> getRequestedProperties() {
        return this.theRequestedProperties;
    }

    public ConversationId getConversationId() {
        return this.theConversationId;
    }

    public int hashCode() {
        return Objects.hash(this.theRequestedProperties, this.theConversationId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SessionPropertiesListenerRegistrationRequest)) {
            return false;
        }
        SessionPropertiesListenerRegistrationRequest other = (SessionPropertiesListenerRegistrationRequest)obj;
        return this.theConversationId.equals(other.theConversationId) && Objects.equals(this.theRequestedProperties, other.theRequestedProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getSimpleName()).append(':').append(this.theConversationId).append(' ');
        if (this.theRequestedProperties == null) {
            sb.append("Deregister");
        } else {
            sb.append("Register [Requested properties=").append(this.theRequestedProperties);
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(2);
        context.put("conversation", this.theConversationId.getId());
        if (this.theRequestedProperties != null) {
            context.put("properties", this.theRequestedProperties);
        }
        return context;
    }
}

