/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.client.features.control.clients.ClientControl;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.client.SessionPropertiesEvent;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.Serialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import com.pushtechnology.diffusion.session.impl.SessionIdSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="session-properties-event", valueType=SessionPropertiesEvent.class)
public class SessionPropertiesEventSerialiser
extends AbstractSerialiser<SessionPropertiesEvent> {
    static final EnumConverter<ClientControl.CloseReason> CLOSE_REASON_CONVERTER = new EnumConverter.Builder<ClientControl.CloseReason>(ClientControl.CloseReason.class).bimap(0, ClientControl.CloseReason.CONNECTION_LOST).bimap(1, ClientControl.CloseReason.IO_EXCEPTION).bimap(2, ClientControl.CloseReason.CLIENT_UNRESPONSIVE).bimap(3, ClientControl.CloseReason.MESSAGE_QUEUE_LIMIT_REACHED).bimap(4, ClientControl.CloseReason.CLOSED_BY_CLIENT).bimap(5, ClientControl.CloseReason.MESSAGE_TOO_LARGE).bimap(6, ClientControl.CloseReason.INTERNAL_ERROR).bimap(7, ClientControl.CloseReason.INVALID_INBOUND_MESSAGE).bimap(8, ClientControl.CloseReason.ABORTED).bimap(9, ClientControl.CloseReason.LOST_MESSAGES).bimap(11, ClientControl.CloseReason.CLOSED_BY_CONTROLLER).bimap(12, ClientControl.CloseReason.FAILED_OVER).bimap(13, ClientControl.CloseReason.EXPIRED).bimap(14, ClientControl.CloseReason.REVOKED).bimap(15, ClientControl.CloseReason.SESSION_TAKEN_OVER).build();
    private static final EnumConverter<ClientControl.SessionPropertiesStream.EventType> UPDATE_TYPE_CONVERTER = new EnumConverter.Builder<ClientControl.SessionPropertiesStream.EventType>(ClientControl.SessionPropertiesStream.EventType.class).bimap(0, ClientControl.SessionPropertiesStream.EventType.UPDATED).bimap(1, ClientControl.SessionPropertiesStream.EventType.RECONNECTED).bimap(2, ClientControl.SessionPropertiesStream.EventType.FAILED_OVER).bimap(3, ClientControl.SessionPropertiesStream.EventType.DISCONNECTED).build();
    private final Serialiser<InternalSessionId> theSessionIdSerialiser;
    private final Serialiser<ConversationId> theConversationIdSerialiser;

    public SessionPropertiesEventSerialiser(SessionIdSerialiser sessionIdSerialiser, ConversationIdSerialiser conversationIdSerialiser) {
        this.theSessionIdSerialiser = sessionIdSerialiser;
        this.theConversationIdSerialiser = conversationIdSerialiser;
    }

    SessionPropertiesEventSerialiser(SessionIdSerialiser sessionIdSerialiser) {
        this(sessionIdSerialiser, null);
    }

    @Override
    public final void write(OutputStream out, SessionPropertiesEvent event) throws IOException {
        if (this.theConversationIdSerialiser != null) {
            this.theConversationIdSerialiser.write(out, event.getContext());
        }
        this.theSessionIdSerialiser.write(out, event.sessionId());
        switch (event.getType()) {
            case OPEN: {
                EncodedDataCodec.writeByte(out, (byte)0);
                SessionPropertiesEventSerialiser.writeStringMap(out, event.getNewProperties());
                break;
            }
            case UPDATE: {
                EncodedDataCodec.writeByte(out, (byte)1);
                EncodedDataCodec.writeByte(out, UPDATE_TYPE_CONVERTER.toByte(event.getUpdateType()));
                this.writeUpdateMaps(out, event.getOldProperties(), event.getNewProperties());
                break;
            }
            case CLOSE: {
                EncodedDataCodec.writeByte(out, (byte)2);
                EncodedDataCodec.writeByte(out, CLOSE_REASON_CONVERTER.toByte(event.closeReason()));
                SessionPropertiesEventSerialiser.writeStringMap(out, event.getOldProperties());
                break;
            }
            default: {
                throw new IOException("Invalid event type");
            }
        }
    }

    protected void writeUpdateMaps(OutputStream out, Map<String, String> oldProperties, Map<String, String> newProperties) throws IOException {
        SessionPropertiesEventSerialiser.writeStringMap(out, this.removeNullValues(oldProperties));
        SessionPropertiesEventSerialiser.writeStringMap(out, newProperties);
    }

    private Map<String, String> removeNullValues(Map<String, String> map) {
        for (String value : map.values()) {
            if (value != null) continue;
            HashMap<String, String> newMap = new HashMap<String, String>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                newMap.put(entry.getKey(), entry.getValue());
            }
            return newMap;
        }
        return map;
    }

    @Override
    protected final SessionPropertiesEvent readUnchecked(InputStream in) throws IOException {
        ConversationId conversationId = this.theConversationIdSerialiser != null ? (ConversationId)this.theConversationIdSerialiser.read(in) : null;
        InternalSessionId sessionId = (InternalSessionId)this.theSessionIdSerialiser.read(in);
        byte option = EncodedDataCodec.readByte(in);
        switch (option) {
            case 0: {
                return SessionPropertiesEvent.createOpenEvent(conversationId, sessionId, SessionPropertiesEventSerialiser.readStringMap(in));
            }
            case 1: {
                return this.completeReadUpdateEvent(in, conversationId, sessionId, UPDATE_TYPE_CONVERTER.fromByte(EncodedDataCodec.readByte(in)));
            }
            case 2: {
                return SessionPropertiesEvent.createCloseEvent(conversationId, sessionId, CLOSE_REASON_CONVERTER.fromByte(EncodedDataCodec.readByte(in)), SessionPropertiesEventSerialiser.readStringMap(in));
            }
        }
        throw new IOException("Invalid option");
    }

    protected SessionPropertiesEvent completeReadUpdateEvent(InputStream in, ConversationId conversationId, InternalSessionId sessionId, ClientControl.SessionPropertiesStream.EventType eventType) throws IOException {
        return SessionPropertiesEvent.createUpdateEvent(conversationId, sessionId, eventType, SessionPropertiesEventSerialiser.readStringMap(in), SessionPropertiesEventSerialiser.readStringMap(in));
    }
}

