/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.journal.Journable;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class SessionEventListenerRegistrationRequest
implements Journable {
    private final boolean thisIsClusterAware;
    private final String theSessionFilter;
    private final Set<String> theRequestedProperties;
    private final long theSessionStartTime;
    private final ConversationId theConversationId;

    public SessionEventListenerRegistrationRequest(boolean clusterAware, String sessionFilter, Set<String> requestedProperties, long sessionStartTime, ConversationId conversationId) {
        this.thisIsClusterAware = clusterAware;
        this.theSessionFilter = sessionFilter;
        this.theRequestedProperties = requestedProperties;
        this.theSessionStartTime = sessionStartTime;
        this.theConversationId = conversationId;
    }

    public boolean isClusterAware() {
        return this.thisIsClusterAware;
    }

    public String getSessionFilter() {
        return this.theSessionFilter;
    }

    public Set<String> getRequestedProperties() {
        return this.theRequestedProperties;
    }

    public long getSessionStartTime() {
        return this.theSessionStartTime;
    }

    public ConversationId getConversationID() {
        return this.theConversationId;
    }

    public int hashCode() {
        return Objects.hash(this.thisIsClusterAware, this.theSessionFilter, this.theRequestedProperties, this.theSessionStartTime, this.theConversationId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SessionEventListenerRegistrationRequest)) {
            return false;
        }
        SessionEventListenerRegistrationRequest other = (SessionEventListenerRegistrationRequest)obj;
        return this.theConversationId.equals(other.theConversationId) && this.thisIsClusterAware == other.thisIsClusterAware && Objects.equals(this.theSessionFilter, other.theSessionFilter) && Objects.equals(this.theRequestedProperties, other.theRequestedProperties) && this.theSessionStartTime == other.theSessionStartTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getSimpleName()).append(':').append(this.theConversationId).append(" [Cluster aware=").append(this.thisIsClusterAware).append(", Session filter=").append(this.theSessionFilter).append(", Requested properties=").append(this.theRequestedProperties);
        if (this.theSessionStartTime != 0L) {
            sb.append(", Session start time=").append(Instant.ofEpochMilli(this.theSessionStartTime));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(5);
        context.putAll(this.theConversationId.getJournableContext());
        if (this.theSessionFilter != null) {
            context.put("filter", this.theSessionFilter);
        }
        if (this.theRequestedProperties != null) {
            context.put("properties", this.theRequestedProperties);
        }
        if (this.theSessionStartTime != 0L) {
            context.put("start", this.theSessionStartTime);
        }
        if (this.thisIsClusterAware) {
            context.put("clustered", true);
        }
        return context;
    }
}

