/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.client.MessagingResponse;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.TrailingBytesWriteSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="messaging-response", valueType=MessagingResponse.class)
public final class MessagingResponseSerialiser
extends AbstractSerialiser<MessagingResponse>
implements TrailingBytesWriteSerialiser<MessagingResponse> {
    private final DataTypes dataTypes;

    public MessagingResponseSerialiser(DataTypes dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    protected MessagingResponse readUnchecked(InputStream in) throws IOException {
        DataType<?> dataType = this.dataTypes.getByName(EncodedDataCodec.readString(in));
        IBytes response = IBytes.toIBytes(EncodedDataCodec.readByteArray(in));
        return new MessagingResponse(dataType, response);
    }

    @Override
    public void writeHead(OutputStream out, MessagingResponse response) throws IOException {
        EncodedDataCodec.writeString(out, response.getDataType().getTypeName());
    }

    @Override
    public IBytes getTail(MessagingResponse response) {
        return response.getResponse();
    }
}

