/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.command.commands.send.MessagingSendRequest;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import net.jcip.annotations.Immutable;

@Immutable
public final class MessagingClientSendRequest {
    private final InternalSessionId session;
    private final String path;
    private final DataType<?> requestDataType;
    private final IBytes request;

    public MessagingClientSendRequest(InternalSessionId session, String path, DataType<?> requestDataType, IBytes request) {
        this.session = session;
        this.path = path;
        this.requestDataType = requestDataType;
        this.request = request;
    }

    public InternalSessionId getSessionId() {
        return this.session;
    }

    public String getPath() {
        return this.path;
    }

    public DataType<?> getRequestDataType() {
        return this.requestDataType;
    }

    public IBytes getRequest() {
        return this.request;
    }

    public MessagingSendRequest asMessagingSendRequest() {
        return new MessagingSendRequest(this.path, this.requestDataType, this.request);
    }

    public int hashCode() {
        int result = this.session.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.requestDataType.hashCode();
        result = 31 * result + this.request.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessagingClientSendRequest)) {
            return false;
        }
        MessagingClientSendRequest other = (MessagingClientSendRequest)o;
        return this.session.equals(other.session) && this.path.equals(other.path) && this.requestDataType == other.requestDataType && this.request.equals(other.request);
    }

    public String toString() {
        return String.format("%s[%s, %s, %s, %s]", this.getClass().getSimpleName(), this.session, this.path, this.requestDataType, this.request);
    }
}

