/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.client.MessagingClientForwardSendRequest;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.TrailingBytesWriteSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import com.pushtechnology.diffusion.session.impl.SessionIdSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="messaging-client-forward-send-request", valueType=MessagingClientForwardSendRequest.class)
public final class MessagingClientForwardSendRequestSerialiser
extends AbstractSerialiser<MessagingClientForwardSendRequest>
implements TrailingBytesWriteSerialiser<MessagingClientForwardSendRequest> {
    private final ConversationIdSerialiser conversationIdSerialiser;
    private final SessionIdSerialiser sessionIdSerialiser;
    private final DataTypes dataTypes;

    public MessagingClientForwardSendRequestSerialiser(ConversationIdSerialiser conversationIdSerialiser, SessionIdSerialiser sessionIdSerialiser, DataTypes dataTypes) {
        this.conversationIdSerialiser = conversationIdSerialiser;
        this.sessionIdSerialiser = sessionIdSerialiser;
        this.dataTypes = dataTypes;
    }

    @Override
    protected MessagingClientForwardSendRequest readUnchecked(InputStream in) throws IOException {
        ConversationId cid = (ConversationId)this.conversationIdSerialiser.read(in);
        InternalSessionId sessionId = (InternalSessionId)this.sessionIdSerialiser.read(in);
        String path = EncodedDataCodec.readString(in);
        Map<String, String> sessionProperties = MessagingClientForwardSendRequestSerialiser.readStringMap(in);
        DataType<?> dataType = this.dataTypes.getByName(EncodedDataCodec.readString(in));
        IBytes request = IBytes.toIBytes(EncodedDataCodec.readByteArray(in));
        return new MessagingClientForwardSendRequest(sessionId, path, dataType, request, sessionProperties, cid);
    }

    @Override
    public void writeHead(OutputStream out, MessagingClientForwardSendRequest request) throws IOException {
        this.conversationIdSerialiser.write(out, request.getContext());
        this.sessionIdSerialiser.write(out, request.getSessionId());
        EncodedDataCodec.writeString(out, request.getPath());
        MessagingClientForwardSendRequestSerialiser.writeStringMap(out, request.getSessionProperties());
        EncodedDataCodec.writeString(out, request.getDataType().getTypeName());
    }

    @Override
    public IBytes getTail(MessagingClientForwardSendRequest request) {
        return request.getRequest();
    }
}

