/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.client;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.client.MessagingClientFilterSendRequest;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.TrailingBytesWriteSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="messaging-client-filter-send-request", valueType=MessagingClientFilterSendRequest.class)
public final class MessagingClientFilterSendRequestSerialiser
extends AbstractSerialiser<MessagingClientFilterSendRequest>
implements TrailingBytesWriteSerialiser<MessagingClientFilterSendRequest> {
    private final DataTypes dataTypes;
    private final ConversationIdSerialiser conversationIdSerialiser;

    public MessagingClientFilterSendRequestSerialiser(DataTypes dataTypes, ConversationIdSerialiser conversationIdSerialiser) {
        this.dataTypes = dataTypes;
        this.conversationIdSerialiser = conversationIdSerialiser;
    }

    @Override
    public MessagingClientFilterSendRequest readUnchecked(InputStream in) throws IOException {
        ConversationId cid = (ConversationId)this.conversationIdSerialiser.read(in);
        String filter = EncodedDataCodec.readString(in);
        String path = EncodedDataCodec.readString(in);
        DataType<?> requestDataType = this.dataTypes.getByName(EncodedDataCodec.readString(in));
        IBytes request = IBytes.toIBytes(EncodedDataCodec.readByteArray(in));
        return new MessagingClientFilterSendRequest(cid, filter, path, requestDataType, request);
    }

    @Override
    public void writeHead(OutputStream out, MessagingClientFilterSendRequest request) throws IOException {
        this.conversationIdSerialiser.write(out, request.getConversationId());
        EncodedDataCodec.writeString(out, request.getFilter());
        EncodedDataCodec.writeString(out, request.getPath());
        EncodedDataCodec.writeString(out, request.getDataType().getTypeName());
    }

    @Override
    public IBytes getTail(MessagingClientFilterSendRequest request) {
        return request.getRequest();
    }
}

