/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.authentication;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.control.authentication.AuthenticatorResponse;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="authenticator-response", valueType=AuthenticatorResponse.class)
public final class AuthenticatorResponseSerialiser
extends AbstractSerialiser<AuthenticatorResponse> {
    private static final EnumConverter<AuthenticatorResponse.TypeCode> TYPE_CODE_CONVERTER = new EnumConverter.Builder<AuthenticatorResponse.TypeCode>(AuthenticatorResponse.TypeCode.class).bimap(0, AuthenticatorResponse.TypeCode.DENY).bimap(1, AuthenticatorResponse.TypeCode.ABSTAIN).bimap(2, AuthenticatorResponse.TypeCode.ALLOW).build();

    @Override
    public void write(OutputStream out, AuthenticatorResponse response) throws IOException {
        AuthenticatorResponse.TypeCode code = response.getType();
        EncodedDataCodec.writeByte(out, TYPE_CODE_CONVERTER.toByte(code));
        if (code == AuthenticatorResponse.TypeCode.ALLOW) {
            AuthenticatorResponseSerialiser.writeStringMap(out, response.getProperties());
        }
    }

    @Override
    protected AuthenticatorResponse readUnchecked(InputStream in) throws IOException {
        AuthenticatorResponse.TypeCode code = TYPE_CODE_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        switch (code) {
            case ABSTAIN: {
                return AuthenticatorResponse.ABSTAIN;
            }
            case ALLOW: {
                return AuthenticatorResponse.allow(AuthenticatorResponseSerialiser.readStringMap(in));
            }
        }
        return AuthenticatorResponse.DENY;
    }
}

