/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.control.authentication;

import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.command.commands.control.AbstractContextInjectable;
import com.pushtechnology.diffusion.conversation.ConversationId;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class AuthenticatorRequest
extends AbstractContextInjectable {
    private final String principal;
    private final Credentials credentials;
    private final Map<String, String> sessionProperties;
    private final Map<String, String> proposedProperties;

    public AuthenticatorRequest(String principal, Credentials credentials, Map<String, String> sessionProperties, Map<String, String> proposedProperties) {
        this(principal, credentials, sessionProperties, proposedProperties, null);
    }

    public AuthenticatorRequest(String principal, Credentials credentials, Map<String, String> sessionProperties, Map<String, String> proposedProperties, ConversationId conversationID) {
        super(conversationID);
        this.principal = principal;
        this.credentials = credentials;
        this.sessionProperties = sessionProperties;
        this.proposedProperties = proposedProperties;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    public Map<String, String> getProposedProperties() {
        return this.proposedProperties;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this.principal.hashCode();
        result = result * 31 + this.credentials.hashCode();
        result = result * 31 + this.sessionProperties.hashCode();
        result = result * 31 + this.proposedProperties.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticatorRequest other = (AuthenticatorRequest)o;
        return this.principal.equals(other.principal) && this.credentials.equals(other.credentials) && this.sessionProperties.equals(other.sessionProperties) && this.proposedProperties.equals(other.proposedProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("AuthenticatorRequest [principal=").append(this.principal).append(", credentials=").append(this.credentials).append(", sessionProperties=").append(this.sessionProperties).append(", proposedProperties=").append(this.proposedProperties).append(", context=").append(super.getContextUnchecked()).append(']');
        return sb.toString();
    }
}

