/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.client.v4;

import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.api.internal.connection.ServerDetailsFactory;
import com.pushtechnology.diffusion.client.internal.routing.TopicRouting;
import com.pushtechnology.diffusion.client.internal.services.MutableServiceRegistry;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.internal.session.InternalSessionFactory;
import com.pushtechnology.diffusion.client.internal.session.SessionConversationSetFactory;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.client.session.proxy.HTTPProxyAuthentication;
import com.pushtechnology.diffusion.client.session.reconnect.ReconnectionStrategy;
import com.pushtechnology.diffusion.command.client.v4.V4InternalSession;
import com.pushtechnology.diffusion.command.client.v4.reconnect.DelayedReconnectionStrategy;
import com.pushtechnology.diffusion.command.client.v4.reconnect.ImmediateAbortReconnectionStrategy;
import com.pushtechnology.diffusion.command.services.ServiceDefinitionRegistry;
import com.pushtechnology.diffusion.comms.connection.CascadeDriver;
import com.pushtechnology.diffusion.comms.connection.ConnectionHandshakeEventListener;
import com.pushtechnology.diffusion.comms.connection.NetworkContextPool;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionFactoryImpl;
import com.pushtechnology.diffusion.comms.connection.ReverseSecondaryConnector;
import com.pushtechnology.diffusion.connection.activity.monitor.SessionActivityMonitor;
import com.pushtechnology.diffusion.conversation.ConversationIdGenerator;
import com.pushtechnology.diffusion.conversation.ConversationSet;
import com.pushtechnology.diffusion.conversation.ConversationSetFactory;
import com.pushtechnology.diffusion.flowcontrol.ConversationSetFlowMeasurement;
import com.pushtechnology.diffusion.flowcontrol.FlowControlBuilder;
import com.pushtechnology.diffusion.io.serialisation.SerialisationContext;
import com.pushtechnology.diffusion.messagequeue.ClientOutboundMessageQueueFactory;
import com.pushtechnology.diffusion.messagequeue.ClientOutboundMessageQueueFactoryImpl;
import com.pushtechnology.diffusion.messagequeue.OutboundQueueConfiguration;
import com.pushtechnology.diffusion.multiplexer.Multiplexer;
import com.pushtechnology.diffusion.multiplexer.MultiplexerSource;
import com.pushtechnology.diffusion.proxy.HTTPProxyNegotiator;
import com.pushtechnology.diffusion.util.concurrent.threads.CommonThreadPools;
import java.util.List;

public class V4SessionFactory
implements InternalSessionFactory {
    private final CommonThreadPools threadPools;
    private final ServiceDefinitionRegistry serviceDefinitions;
    private final SerialisationContext serialisers;
    private final ConversationSetFactory conversationSetFactory;
    private final FlowControlBuilder flowControlBuilder;
    private final MultiplexerSource<Multiplexer> multiplexerSource;
    private final ClientOutboundMessageQueueFactory messageQueueFactory = new ClientOutboundMessageQueueFactoryImpl();
    private final NetworkContextPool networkContexts;
    private final CascadeDriver cascadeDriver;
    private final ReverseSecondaryConnector reverseSecondaryConnector;

    public V4SessionFactory(CommonThreadPools threadPools, ServiceDefinitionRegistry serviceDefinitions, SerialisationContext serialisers, ConversationSetFactory conversationSetFactory, FlowControlBuilder flowControlBuilder, MultiplexerSource<Multiplexer> multiplexerSource, NetworkContextPool networkContexts, CascadeDriver cascadeDriver, ReverseSecondaryConnector reverseSecondaryConnector) {
        this.threadPools = threadPools;
        this.serviceDefinitions = serviceDefinitions;
        this.serialisers = serialisers;
        this.conversationSetFactory = conversationSetFactory;
        this.flowControlBuilder = flowControlBuilder;
        this.multiplexerSource = multiplexerSource;
        this.networkContexts = networkContexts;
        this.cascadeDriver = cascadeDriver;
        this.reverseSecondaryConnector = reverseSecondaryConnector;
    }

    @Override
    public InternalSession create(SessionAttributes sessionAttributes, MutableServiceRegistry serviceRegistry, SessionActivityMonitor sessionActivityMonitor, TopicRouting topicRouting, ConnectionHandshakeEventListener cascadeEventListener) {
        List<ServerDetails> serverDetailsList = ServerDetailsFactory.create(sessionAttributes);
        String proxyHost = sessionAttributes.getHttpProxyHost();
        int proxyPort = sessionAttributes.getHttpProxyPort();
        if (proxyHost != null && proxyPort >= 0) {
            HTTPProxyAuthentication.ChallengeHandler challengeHandler = sessionAttributes.getHttpProxyAuth().createHandler(sessionAttributes);
            for (ServerDetails serverDetails : serverDetailsList) {
                serverDetails.setProxyConnector(new HTTPProxyNegotiator(proxyHost, proxyPort, challengeHandler, 2000, sessionAttributes.getOutputBufferSize(), sessionAttributes.getInputBufferSize()));
            }
        }
        int reconnectionTimeout = sessionAttributes.getReconnectionTimeout();
        ReconnectionStrategy configured = sessionAttributes.getReconnectionStrategy();
        ReconnectionStrategy reconnectionStrategy = configured != null ? configured : (reconnectionTimeout > 0 ? new DelayedReconnectionStrategy(this.threadPools) : new ImmediateAbortReconnectionStrategy());
        SessionConversationSetFactory sessionConversationSetFactory = new SessionConversationSetFactory(this.conversationSetFactory, new ConversationIdGenerator());
        ConversationSet conversations = sessionConversationSetFactory.newConversationSet();
        int maximumQueueSize = sessionAttributes.getMaximumQueueSize();
        ConversationSetFlowMeasurement conversationFlowMeasurement = new ConversationSetFlowMeasurement(conversations, maximumQueueSize);
        OutboundConnectionFactoryImpl connectionFactory = OutboundConnectionFactoryImpl.createOutboundConnectionFactory(this.networkContexts, this.multiplexerSource, this.messageQueueFactory, this.flowControlBuilder.with(conversationFlowMeasurement), this.threadPools.getDefaultInboundThreadPool(), this.cascadeDriver, this.reverseSecondaryConnector, sessionAttributes.getMaximumMessageSize());
        return new V4InternalSession(connectionFactory, this.threadPools, this.serialisers, sessionConversationSetFactory, conversations, conversationFlowMeasurement, serviceRegistry, this.serviceDefinitions, OutboundQueueConfiguration.DEFAULT_QUEUE_CONFIGURATION.withMaximumQueueSize(maximumQueueSize), serverDetailsList, reconnectionStrategy, reconnectionTimeout, sessionAttributes.getRecoveryBufferSize(), sessionActivityMonitor, topicRouting, cascadeEventListener);
    }
}

