/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.ClusterRepartitionException;
import com.pushtechnology.diffusion.client.features.ClusterRoutingException;
import com.pushtechnology.diffusion.client.features.HandlerConflictException;
import com.pushtechnology.diffusion.client.features.IncompatibleDatatypeException;
import com.pushtechnology.diffusion.client.features.IncompatibleTopicException;
import com.pushtechnology.diffusion.client.features.IncompatibleTopicStateException;
import com.pushtechnology.diffusion.client.features.InvalidUpdateStreamException;
import com.pushtechnology.diffusion.client.features.NoSuchSessionException;
import com.pushtechnology.diffusion.client.features.NoSuchTopicException;
import com.pushtechnology.diffusion.client.features.RejectedRequestException;
import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.UnhandledMessageException;
import com.pushtechnology.diffusion.client.features.UnsatisfiedConstraintException;
import com.pushtechnology.diffusion.client.features.UpdateFailedException;
import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.features.control.topics.SessionTrees;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.internal.services.RegisteredHandlerException;
import com.pushtechnology.diffusion.client.session.PermissionsException;
import com.pushtechnology.diffusion.client.session.SessionClosedException;
import com.pushtechnology.diffusion.client.session.SessionException;
import com.pushtechnology.diffusion.command.sender.UnsupportedServiceRequestException;
import com.pushtechnology.diffusion.exceptions.DiffusionRuntimeException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import net.jcip.annotations.Immutable;

@Immutable
public final class ErrorReasonException
extends DiffusionRuntimeException {
    private static final long serialVersionUID = 6640373042710647540L;
    private final ErrorReason reason;
    public static final ErrorReason INCOMPATIBLE_UPDATE = new ErrorReason(500, "Update type is incompatible with topic type");
    public static final ErrorReason UPDATE_FAILED = new ErrorReason(501, "Update failed - possible content incompatibility");
    public static final ErrorReason MISSING_TOPIC = new ErrorReason(503, "Topic does not exist");
    public static final ErrorReason DELTA_WITHOUT_VALUE = new ErrorReason(505, "An attempt has been made to apply a delta to a topic that does not yet have a value");
    public static final ErrorReason NO_SUCH_TOPIC = new ErrorReason(9000, "No topic was found");
    public static final ErrorReason NOT_A_TIMESERIES_TOPIC = new ErrorReason(9001, "Topic is not a time series topic");
    public static final ErrorReason NO_SUCH_EVENT = new ErrorReason(9002, "No time series event was found");
    public static final ErrorReason REJECTED_REQUEST = new ErrorReason(9003, "A request has been rejected by the recipient session");
    public static final ErrorReason TOPIC_EXISTS_MISMATCH = new ErrorReason(9004, "A topic could not be added because one already exists with a different specification");
    public static final ErrorReason TOPIC_PATH_INVALID = new ErrorReason(9005, "A topic could not be added because an invalid path was specified");
    public static final ErrorReason TOPIC_SPECIFICATION_INVALID = new ErrorReason(9006, "A topic could not be added because an invalid specification was supplied");
    public static final ErrorReason TOPIC_LICENSE_LIMIT = new ErrorReason(9007, "A topic could not be added because the topic would breach a licensing limit");
    public static final ErrorReason INCOMPATIBLE_TOPIC_EXISTS = new ErrorReason(9010, "A topic could not be added because an incompatible topic already exists at the specified path");
    public static final ErrorReason UNEXPECTED_TOPIC_ADD_FAILURE = new ErrorReason(9011, "An unexpected error occurred when creating a topic");
    public static final ErrorReason UNSATISFIED_CONSTRAINT = new ErrorReason(9012, "The topic update failed because the constraint was not satisfied");
    public static final ErrorReason INVALID_UPDATE_STREAM = new ErrorReason(9013, "The topic update failed because the update stream is no longer valid");
    public static final ErrorReason INVALID_JSON_PATCH = new ErrorReason(9014, "Parsing the JSON patch failed");
    public static final ErrorReason APPLY_PATCH_FAIL = new ErrorReason(9015, "The JSON patch failed to apply. This happens when attempting to parse an illegal CBOR value.");
    public static final ErrorReason REMOTE_SERVER_EXISTS = new ErrorReason(9016, "A remote server with the specified name already exists");
    public static final ErrorReason INVALID_BRANCH_MAPPING = new ErrorReason(9017, "An invalid branch mapping was supplied");
    private static final Map<Integer, Function<String, Exception>> CODE_TO_EXCEPTION = new HashMap<Integer, Function<String, Exception>>();
    private static final Map<Class<? extends Exception>, ErrorReason> EXCEPTION_TO_CODE = new HashMap<Class<? extends Exception>, ErrorReason>();

    private static void mapException(ErrorReason reason, Function<String, Exception> constructor) {
        CODE_TO_EXCEPTION.put(reason.getReasonCode(), constructor);
        EXCEPTION_TO_CODE.put(constructor.apply("").getClass(), reason);
    }

    public ErrorReasonException(ErrorReason errorReason) {
        this(errorReason, errorReason.toString());
    }

    private ErrorReasonException(ErrorReason errorReason, String description) {
        super(description);
        this.reason = errorReason;
    }

    public ErrorReason getErrorReason() {
        return this.reason;
    }

    public static Throwable toApiException(Throwable t) {
        if (t instanceof ErrorReasonException) {
            ErrorReasonException r = (ErrorReasonException)t;
            Function<String, Exception> translation = CODE_TO_EXCEPTION.get(r.reason.getReasonCode());
            if (translation != null) {
                return translation.apply(r.reason.getDescription());
            }
            return new SessionException(r);
        }
        return t;
    }

    public static Exception toApiException(ErrorReason errorReason, String description) {
        Function<String, Exception> translation = CODE_TO_EXCEPTION.get(errorReason.getReasonCode());
        if (translation != null) {
            return translation.apply(description);
        }
        return new SessionException(new ErrorReasonException(errorReason, description));
    }

    public static ErrorReason serviceExceptionToErrorReason(Throwable t) {
        if (t instanceof SessionClosedException) {
            return ErrorReason.NO_SUCH_SESSION;
        }
        if ("AccessDeniedException".equals(t.getClass().getSimpleName())) {
            return ErrorReason.ACCESS_DENIED;
        }
        return ErrorReasonException.localExceptionToErrorReason(t);
    }

    public static ErrorReason localExceptionToErrorReason(Throwable t) {
        if (t instanceof ErrorReasonException) {
            return ((ErrorReasonException)t).getErrorReason();
        }
        return EXCEPTION_TO_CODE.getOrDefault(t.getClass(), ErrorReason.COMMUNICATION_FAILURE);
    }

    public static ErrorReasonException incompatibleTimeSeriesTopicException(String message) {
        return new ErrorReasonException(NOT_A_TIMESERIES_TOPIC, message);
    }

    static {
        ErrorReasonException.mapException(ErrorReason.ACCESS_DENIED, PermissionsException::new);
        ErrorReasonException.mapException(MISSING_TOPIC, NoSuchTopicException::new);
        ErrorReasonException.mapException(NO_SUCH_TOPIC, NoSuchTopicException::new);
        ErrorReasonException.mapException(ErrorReason.HANDLER_CONFLICT, HandlerConflictException::new);
        ErrorReasonException.mapException(NOT_A_TIMESERIES_TOPIC, IncompatibleTopicException::new);
        ErrorReasonException.mapException(INCOMPATIBLE_UPDATE, IncompatibleTopicException::new);
        ErrorReasonException.mapException(UPDATE_FAILED, UpdateFailedException::new);
        ErrorReasonException.mapException(NO_SUCH_EVENT, TimeSeries.NoSuchEventException::new);
        ErrorReasonException.mapException(ErrorReason.NO_SUCH_SESSION, NoSuchSessionException::new);
        ErrorReasonException.mapException(ErrorReason.UNHANDLED_MESSAGE, UnhandledMessageException::new);
        ErrorReasonException.mapException(ErrorReason.INCOMPATIBLE_DATATYPE, IncompatibleDatatypeException::new);
        ErrorReasonException.mapException(REJECTED_REQUEST, RejectedRequestException::new);
        ErrorReasonException.mapException(ErrorReason.REQUEST_TIME_OUT, CancellationException::new);
        ErrorReasonException.mapException(ErrorReason.CLUSTER_ROUTING, ClusterRoutingException::new);
        ErrorReasonException.mapException(ErrorReason.CLUSTER_REPARTITION, ClusterRepartitionException::new);
        ErrorReasonException.mapException(TOPIC_EXISTS_MISMATCH, TopicControl.ExistingTopicException::new);
        ErrorReasonException.mapException(TOPIC_PATH_INVALID, TopicControl.InvalidTopicPathException::new);
        ErrorReasonException.mapException(TOPIC_SPECIFICATION_INVALID, TopicControl.InvalidTopicSpecificationException::new);
        ErrorReasonException.mapException(TOPIC_LICENSE_LIMIT, TopicControl.TopicLicenseLimitException::new);
        ErrorReasonException.mapException(INCOMPATIBLE_TOPIC_EXISTS, TopicControl.IncompatibleExistingTopicException::new);
        ErrorReasonException.mapException(UNEXPECTED_TOPIC_ADD_FAILURE, TopicControl.AddTopicException::new);
        ErrorReasonException.mapException(UNSATISFIED_CONSTRAINT, UnsatisfiedConstraintException::new);
        ErrorReasonException.mapException(ErrorReason.INCOMPATIBLE_STATE, IncompatibleTopicStateException::new);
        ErrorReasonException.mapException(INVALID_UPDATE_STREAM, InvalidUpdateStreamException::new);
        ErrorReasonException.mapException(INVALID_JSON_PATCH, TopicUpdate.InvalidPatchException::new);
        ErrorReasonException.mapException(APPLY_PATCH_FAIL, TopicUpdate.FailedPatchException::new);
        ErrorReasonException.mapException(REMOTE_SERVER_EXISTS, RemoteServers.RemoteServerExistsException::new);
        ErrorReasonException.mapException(INVALID_BRANCH_MAPPING, SessionTrees.InvalidBranchMappingException::new);
        EXCEPTION_TO_CODE.put(SessionClosedException.class, ErrorReason.SESSION_CLOSED);
        EXCEPTION_TO_CODE.put(UnsupportedServiceRequestException.class, ErrorReason.UNSUPPORTED);
        EXCEPTION_TO_CODE.put(RegisteredHandlerException.class, ErrorReason.CALLBACK_EXCEPTION);
    }
}

