/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.collections;

import com.pushtechnology.diffusion.collections.InternSet;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class WeakInternSet<E>
implements InternSet<E> {
    private final Map<E, WeakReference<E>> set;

    public WeakInternSet() {
        this(1024, 0.75f);
    }

    public WeakInternSet(int initialCapacity, float loadFactor) {
        this.set = new WeakHashMap<E, WeakReference<E>>(initialCapacity, loadFactor);
    }

    @Override
    public synchronized E intern(E e) {
        Object existing;
        if (e == null) {
            return null;
        }
        Reference reference = this.set.get(e);
        if (reference != null && (existing = reference.get()) != null) {
            return (E)existing;
        }
        this.set.put(e, new WeakReference<E>(e));
        return e;
    }
}

