/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.collections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ImmutableSet<V>
extends AbstractSet<V>
implements Serializable {
    private static final long serialVersionUID = 6572867770359003254L;
    private static final ImmutableSet<Object> EMPTY = new Empty();
    private final V[] array;

    public static <V> ImmutableSet<V> empty() {
        return EMPTY;
    }

    @SafeVarargs
    public static <V> ImmutableSet<V> of(V ... a) {
        int l = a.length;
        if (l == 0) {
            return ImmutableSet.empty();
        }
        if (l == 1) {
            return new ImmutableSet<V>(a);
        }
        LinkedHashSet<V> unique = new LinkedHashSet<V>(l);
        for (V v : a) {
            unique.add(v);
        }
        return new ImmutableSet(ImmutableSet.collectionToArray(unique));
    }

    public static <V> ImmutableSet<V> from(Set<? extends V> vs) {
        if (vs.isEmpty()) {
            return ImmutableSet.empty();
        }
        if (vs instanceof ImmutableSet) {
            return ImmutableSet.safeCast((ImmutableSet)vs);
        }
        return new ImmutableSet<V>(ImmutableSet.collectionToArray(vs));
    }

    public static <V> ImmutableSet<V> from(Collection<? extends V> vs) {
        int l = vs.size();
        if (l == 0) {
            return ImmutableSet.empty();
        }
        if (l == 1) {
            return new ImmutableSet<V>(ImmutableSet.collectionToArray(vs));
        }
        return new ImmutableSet<V>(ImmutableSet.collectionToArray(new LinkedHashSet<V>(vs)));
    }

    protected static final <V> V[] collectionToArray(Collection<? extends V> vs) {
        if (vs instanceof ImmutableSet) {
            return ImmutableSet.safeCast((ImmutableSet)vs).array;
        }
        Object[] array2 = vs.toArray();
        return array2;
    }

    protected static final <V> ImmutableSet<V> safeCast(ImmutableSet<? extends V> vs) {
        return vs;
    }

    protected ImmutableSet(V[] array) {
        this.array = array;
    }

    protected final V[] array() {
        return this.array;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < ImmutableSet.this.array.length;
            }

            @Override
            public V next() {
                int p;
                if ((p = this.i++) >= ImmutableSet.this.array.length) {
                    throw new NoSuchElementException();
                }
                return ImmutableSet.this.array[p];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean contains(Object o) {
        for (V v : this.array) {
            if (!Objects.equals(v, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.array.length) {
            return this.toArray();
        }
        return super.toArray(a);
    }

    public ImmutableSet<V> with(V v) {
        if (this.contains(v)) {
            return this;
        }
        V[] a = Arrays.copyOf(this.array, this.array.length + 1);
        a[this.array.length] = v;
        return new ImmutableSet<V>(a);
    }

    public ImmutableSet<V> without(V v) {
        return this.withoutFirst(e -> e.equals(v));
    }

    public ImmutableSet<V> without(Predicate<? super V> predicate) {
        V[] a = this.arrayWithout(predicate);
        return a == this.array ? this : new ImmutableSet<V>(a);
    }

    protected final V[] arrayWithout(Predicate<? super V> predicate) {
        V[] temporary = null;
        int j = 0;
        for (V v : this.array) {
            if (!predicate.test(v)) {
                if (temporary != null) {
                    temporary[j] = v;
                }
                ++j;
                continue;
            }
            if (temporary != null) continue;
            temporary = Arrays.copyOf(this.array, this.array.length);
        }
        return temporary == null ? this.array : Arrays.copyOf(temporary, j);
    }

    public ImmutableSet<V> withoutFirst(Predicate<? super V> predicate) {
        V[] a = this.arrayWithoutFirst(predicate);
        return a == this.array ? this : new ImmutableSet<V>(a);
    }

    protected final V[] arrayWithoutFirst(Predicate<? super V> predicate) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!predicate.test(this.array[i])) continue;
            return ImmutableSet.arrayWithout(this.array, i);
        }
        return this.array;
    }

    protected static final <V> V[] arrayWithout(V[] a, int i) {
        V[] b = Arrays.copyOf(a, a.length - 1);
        System.arraycopy(a, i + 1, b, i, b.length - i);
        return b;
    }

    public ImmutableSet<V> withAll(Collection<? extends V> vs) {
        if (this.containsAll(vs)) {
            return this;
        }
        LinkedHashSet<V> temporary = new LinkedHashSet<V>(this.size() + vs.size());
        temporary.addAll(this);
        temporary.addAll(vs);
        return new ImmutableSet(ImmutableSet.collectionToArray(temporary));
    }

    private static final class Empty
    extends ImmutableSet<Object> {
        private static final long serialVersionUID = -8322723896851598648L;

        private Empty() {
            super(new Object[0]);
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void forEach(Consumer<Object> action) {
            Objects.requireNonNull(action);
        }

        @Override
        public boolean removeIf(Predicate<Object> filter) {
            Objects.requireNonNull(filter);
            return false;
        }

        @Override
        public Spliterator<Object> spliterator() {
            return Spliterators.emptySpliterator();
        }
    }
}

