/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class ExpandableArray<E>
implements Iterable<E> {
    private static final int INITIAL_CAPACITY = 256;
    private Object[] elementData;

    public ExpandableArray() {
        this(256);
    }

    public ExpandableArray(int initialCapacity) {
        this.elementData = new Object[initialCapacity];
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity - oldCapacity > 0) {
            this.grow(minCapacity, oldCapacity);
        }
    }

    private void grow(int minCapacity, int oldCapacity) {
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    public void set(int i, E e) {
        this.ensureCapacity(i + 1);
        this.elementData[i] = e;
    }

    public E getAndSet(int i, E newValue) {
        E result = this.get(i);
        this.set(i, newValue);
        return result;
    }

    public E get(int i) {
        if (i < 0 || i >= this.elementData.length) {
            return null;
        }
        return this.getUnchecked(i);
    }

    public E getOrDefault(int i, E defaultValue) {
        E v = this.get(i);
        return v != null ? v : defaultValue;
    }

    public E getUnchecked(int i) {
        Object result = this.elementData[i];
        return (E)result;
    }

    public E computeIfAbsent(int i, Supplier<? extends E> supplier) {
        this.ensureCapacity(i + 1);
        E existing = this.getUnchecked(i);
        if (existing != null) {
            return existing;
        }
        E newValue = supplier.get();
        this.elementData[i] = newValue;
        return newValue;
    }

    private int findNext(int old) {
        int length = this.elementData.length;
        for (int i = old + 1; i < length; ++i) {
            if (this.elementData[i] == null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int next;
            {
                this.next = ExpandableArray.this.findNext(-1);
            }

            @Override
            public boolean hasNext() {
                return this.next >= 0;
            }

            @Override
            public E next() {
                if (this.next < 0) {
                    throw new NoSuchElementException();
                }
                Object result = ExpandableArray.this.getUnchecked(this.next);
                this.next = ExpandableArray.this.findNext(this.next);
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        int i = this.findNext(-1);
        while (i >= 0) {
            action.accept(this.getUnchecked(i));
            i = this.findNext(i);
        }
    }
}

