/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.types.serialisation;

import java.lang.reflect.Array;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class EnumConverter<E extends Enum<E>> {
    private final Class<E> type;
    private final EnumMap<E, Byte> theValues;
    private final E[] theConstants;

    private EnumConverter(Class<E> type, EnumMap<E, Byte> values, E[] constants) {
        this.type = type;
        this.theValues = values;
        this.theConstants = constants;
    }

    public E fromByte(byte byteValue) {
        try {
            E result = this.theConstants[byteValue & 0xFF];
            if (result == null) {
                throw new IllegalArgumentException("No constant for " + byteValue);
            }
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("No constant for " + byteValue, e);
        }
    }

    public E fromByte(byte byteValue, E defaultValue) {
        int i = byteValue & 0xFF;
        if (i >= this.theConstants.length) {
            return defaultValue;
        }
        E e = this.theConstants[i];
        return e != null ? e : defaultValue;
    }

    public byte toByte(E constant) {
        Byte b = this.theValues.get(Objects.requireNonNull(constant));
        if (b == null) {
            throw new IllegalArgumentException("No mapping for " + String.valueOf(constant));
        }
        return b;
    }

    public boolean isMapped(E constant) {
        return this.theValues.containsKey(constant);
    }

    public long setToLong(Set<E> set) {
        long result = 0L;
        for (Enum e : set) {
            byte v = this.toByte(e);
            if (v >= 64) {
                throw new IllegalArgumentException("Cannot encode " + String.valueOf(e) + " in long, " + v + " >= 64");
            }
            if (this.theConstants[v] == null) {
                throw new IllegalArgumentException(String.valueOf(e) + "->" + v + " has no reverse mapping");
            }
            result |= (long)(1 << v);
        }
        return result;
    }

    public Set<E> longToSet(long l, E defaultValue) {
        EnumSet<E> result = EnumSet.noneOf(this.type);
        long bits = l;
        int z;
        while ((z = Long.numberOfLeadingZeros(bits)) != 64) {
            byte v = (byte)(63 - z);
            bits ^= (long)(1 << v);
            result.add(this.fromByte(v, defaultValue));
        }
        return result;
    }

    public static final class Builder<E extends Enum<E>> {
        private final Class<E> type;
        private final Map<Integer, E> forward = new HashMap<Integer, E>();
        private final Set<E> unmapped = new HashSet();
        private final EnumMap<E, Byte> reverse;
        private int highestByte;

        public Builder(Class<E> type) {
            this.type = type;
            this.reverse = new EnumMap(type);
        }

        public EnumConverter<E> build() {
            for (Enum e : (Enum[])this.type.getEnumConstants()) {
                if (this.reverse.get(e) != null || this.unmapped.contains(e)) continue;
                throw new IllegalStateException("No mapping for " + String.valueOf(e));
            }
            Enum[] constants = Builder.allocateConstants(this.type, (int)(this.highestByte + 1));
            for (Map.Entry<Integer, E> e : this.forward.entrySet()) {
                constants[e.getKey().intValue()] = (Enum)e.getValue();
            }
            return new EnumConverter(this.type, new EnumMap<E, Byte>(this.reverse), constants);
        }

        public Builder<E> bimap(int unsignedByte, E c) {
            this.map(unsignedByte, c);
            return this.map(c, unsignedByte);
        }

        public Builder<E> map(int unsignedByte, E c) {
            if (this.forward.put(this.addByte(unsignedByte), c) != null) {
                throw new IllegalStateException("Duplicate mapping for " + String.valueOf(c));
            }
            return this;
        }

        public Builder<E> map(E c, int unsignedByte) {
            if (this.reverse.put(c, (byte)this.addByte(unsignedByte)) != null) {
                throw new IllegalStateException("Duplicate mapping for " + String.valueOf(c));
            }
            return this;
        }

        public Builder<E> unmapped(E c) {
            this.unmapped.add(c);
            this.reverse.remove(c);
            return this;
        }

        private int addByte(int b) {
            if (b > 255 || b < 0) {
                throw new IllegalArgumentException("Illegal byte: " + b);
            }
            int result = b & 0xFF;
            this.highestByte = Math.max(this.highestByte, result);
            return result;
        }

        private static <E extends Enum<E>> E[] allocateConstants(Class<E> type, int size) {
            return (Enum[])Array.newInstance(type, size);
        }
    }
}

