/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.types.impl;

import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.client.types.impl.CredentialsImpl;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="credentials", valueType=Credentials.class)
public final class CredentialsSerialiser
extends AbstractSerialiser<Credentials> {
    private static final EnumConverter<Credentials.Type> TYPE_CONVERTER = new EnumConverter.Builder<Credentials.Type>(Credentials.Type.class).bimap(0, Credentials.Type.NONE).bimap(1, Credentials.Type.PLAIN_PASSWORD).bimap(2, Credentials.Type.CUSTOM).build();

    @Override
    public void write(OutputStream out, Credentials value) throws IOException {
        EncodedDataCodec.writeByte(out, TYPE_CONVERTER.toByte(value.getType()));
        EncodedDataCodec.writeByteArray(out, value.toBytes());
    }

    @Override
    public Credentials readUnchecked(InputStream in) throws IOException {
        Credentials.Type type = TYPE_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        byte[] bytes = EncodedDataCodec.readByteArray(in);
        return new CredentialsImpl(type, bytes);
    }
}

