/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.types.impl;

import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.util.Arrays;
import net.jcip.annotations.Immutable;

@Immutable
public final class CredentialsImpl
implements Credentials {
    public static final Credentials NO_CREDENTIALS = new CredentialsImpl(Credentials.Type.NONE, new byte[0]);
    private final Credentials.Type type;
    private final byte[] bytes;

    public static Credentials createPasswordCredentials(String password) {
        return new CredentialsImpl(Credentials.Type.PLAIN_PASSWORD, CharsetUtils.stringToBytesUTF8(password));
    }

    public CredentialsImpl(Credentials.Type type, byte[] bytes) {
        this.type = type;
        this.bytes = bytes;
    }

    @Override
    public Credentials.Type getType() {
        return this.type;
    }

    @Override
    public byte[] toBytes() {
        return this.bytes;
    }

    public int hashCode() {
        int prime = 31;
        return this.type.hashCode() * 31 + Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialsImpl other = (CredentialsImpl)o;
        return this.type == other.type && Arrays.equals(this.bytes, other.bytes);
    }

    public String toString() {
        return this.type.toString();
    }
}

