/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.retry;

import java.util.Objects;

public final class RetryStrategy {
    public static final RetryStrategy NO_RETRY = new RetryStrategy();
    private final long interval;
    private final int attempts;

    public RetryStrategy(long interval, int attempts) {
        if (interval < 1L) {
            throw new IllegalArgumentException("Invalid interval");
        }
        this.interval = interval;
        if (attempts < 1) {
            throw new IllegalArgumentException("Invalid attempts");
        }
        this.attempts = attempts;
    }

    public RetryStrategy(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("Invalid interval");
        }
        this.interval = interval;
        this.attempts = Integer.MAX_VALUE;
    }

    private RetryStrategy() {
        this.interval = 0L;
        this.attempts = 0;
    }

    public long getInterval() {
        return this.interval;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.attempts);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RetryStrategy)) {
            return false;
        }
        RetryStrategy other = (RetryStrategy)obj;
        return this.interval == other.interval && this.attempts == other.attempts;
    }

    public String toString() {
        if (this.attempts == 0) {
            return "RetryStrategy [No retry]";
        }
        if (this.attempts == Integer.MAX_VALUE) {
            return "RetryStrategy [interval=" + this.interval + "ms, attempts=unlimited]";
        }
        return "RetryStrategy [interval=" + this.interval + "ms, attempts=" + this.attempts + "]";
    }
}

