/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.java7.Java7;
import com.pushtechnology.diffusion.journal.Journable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class SessionLockRequest
implements Journable {
    private final String lockName;
    private final long requestId;
    private final Session.SessionLockScope scope;

    public SessionLockRequest(String lockName, long requestId, Session.SessionLockScope scope) {
        this.lockName = lockName;
        this.requestId = requestId;
        this.scope = scope;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public Session.SessionLockScope getScope() {
        return this.scope;
    }

    public int hashCode() {
        int result = this.lockName.hashCode();
        result = 31 * result + Java7.longHashCode(this.requestId);
        result = 31 * result + this.scope.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionLockRequest)) {
            return false;
        }
        SessionLockRequest other = (SessionLockRequest)o;
        return this.requestId == other.requestId && this.scope == other.scope && this.lockName.equals(other.lockName);
    }

    public String toString() {
        return "SessionLockRequest[" + this.lockName + "," + this.requestId + ", " + String.valueOf((Object)this.scope) + "]";
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(3);
        context.put("lock", this.lockName);
        context.put("id", this.requestId);
        context.put("scope", (Object)this.scope);
        return context;
    }
}

