/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.session.impl;

import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.client.session.proxy.HTTPProxyAuthentication;
import com.pushtechnology.diffusion.client.session.reconnect.ReconnectionStrategy;
import com.pushtechnology.diffusion.client.session.retry.RetryStrategy;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import net.jcip.annotations.Immutable;

@Immutable
final class SessionAttributesImpl
implements SessionAttributes {
    private final String theServerURL;
    private final int theConnectionTimeout;
    private final int theWriteTimeout;
    private final int theInputBufferSize;
    private final int theOutputBufferSize;
    private final int theMaximumMessageSize;
    private final RetryStrategy theInitialRetryStrategy;
    private final int reconnectionTimeout;
    private final ReconnectionStrategy reconnectionStrategy;
    private final SocketAddress theLocalSocketAddress;
    private final SSLContext theSSLContext;
    private final HTTPProxyAuthentication theProxyAuth;
    private final String theProxyHost;
    private final int theProxyPort;
    private final String serverHost;
    private final int serverPort;
    private final List<SessionAttributes.Transport> requestedTransports;
    private final boolean isTransportSecure;
    private final String requestPath;
    private final int recoveryBufferSize;
    private final int theMaximumQueueSize;

    SessionAttributesImpl(String serverURL, int connectionTimeout, int writeTimeout, int inputBufferSize, int outputBufferSize, int maximumMessageSize, RetryStrategy initialRetryStrategy, int reconnectionTimeout, ReconnectionStrategy reconnectionStrategy, SocketAddress localSocketAddress, SSLContext sslContext, HTTPProxyAuthentication proxyAuth, String proxyHost, int proxyPort, String serverHost, int serverPort, List<SessionAttributes.Transport> requestedTransports, boolean isTransportSecure, String requestPath, int recoveryBufferSize, int maximumQueueSize) {
        this.theServerURL = serverURL;
        this.theConnectionTimeout = connectionTimeout;
        this.theWriteTimeout = writeTimeout;
        this.theInputBufferSize = inputBufferSize;
        this.theOutputBufferSize = outputBufferSize;
        this.theMaximumMessageSize = maximumMessageSize;
        this.theInitialRetryStrategy = initialRetryStrategy;
        this.reconnectionStrategy = reconnectionStrategy;
        this.reconnectionTimeout = reconnectionTimeout;
        this.theLocalSocketAddress = localSocketAddress;
        this.theSSLContext = sslContext;
        this.theProxyAuth = proxyAuth;
        this.theProxyHost = proxyHost;
        this.theProxyPort = proxyPort;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.requestedTransports = Collections.unmodifiableList(new ArrayList<SessionAttributes.Transport>(requestedTransports));
        this.isTransportSecure = isTransportSecure;
        this.requestPath = requestPath;
        this.recoveryBufferSize = recoveryBufferSize;
        this.theMaximumQueueSize = maximumQueueSize;
    }

    @Override
    public String getServerURL() {
        return this.theServerURL;
    }

    @Override
    public int getConnectionTimeout() {
        return this.theConnectionTimeout;
    }

    @Override
    public int getInputBufferSize() {
        return this.theInputBufferSize;
    }

    @Override
    public int getOutputBufferSize() {
        return this.theOutputBufferSize;
    }

    @Override
    public int getWriteTimeout() {
        return this.theWriteTimeout;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.theLocalSocketAddress;
    }

    @Override
    public SSLContext getSslContext() {
        return this.theSSLContext;
    }

    @Override
    public int getMaximumMessageSize() {
        return this.theMaximumMessageSize;
    }

    @Override
    public HTTPProxyAuthentication getHttpProxyAuth() {
        return this.theProxyAuth;
    }

    @Override
    public String getHttpProxyHost() {
        return this.theProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.theProxyPort;
    }

    @Override
    public RetryStrategy getInitialRetryStrategy() {
        return this.theInitialRetryStrategy;
    }

    @Override
    public int getReconnectionTimeout() {
        return this.reconnectionTimeout;
    }

    @Override
    public ReconnectionStrategy getReconnectionStrategy() {
        return this.reconnectionStrategy;
    }

    @Override
    public String getServerHost() {
        return this.serverHost;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public List<SessionAttributes.Transport> getRequestedTransports() {
        return this.requestedTransports;
    }

    @Override
    public boolean isTransportSecure() {
        return this.isTransportSecure;
    }

    @Override
    public String getRequestPath() {
        return this.requestPath;
    }

    @Override
    public int getRecoveryBufferSize() {
        return this.recoveryBufferSize;
    }

    @Override
    public int getMaximumQueueSize() {
        return this.theMaximumQueueSize;
    }
}

