/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.streams;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.Messaging;
import com.pushtechnology.diffusion.client.internal.streams.RequestStreamParameters;
import com.pushtechnology.diffusion.client.internal.streams.RequestStreamRegistry;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class RequestStreamRegistryImpl
implements RequestStreamRegistry {
    @GuardedBy(value="streams")
    private final Map<String, RequestStreamParameters> streams = new HashMap<String, RequestStreamParameters>();
    private final DataTypes dataTypes;

    public RequestStreamRegistryImpl(DataTypes dataTypes) {
        this.dataTypes = dataTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, R> Messaging.RequestStream<?, ?> add(String path, Class<? extends T> requestType, Class<? super R> responseType, Messaging.RequestStream<T, R> requestStream) {
        DataType<? super R> responseDataType = this.dataTypes.getByClass(responseType);
        Map<String, RequestStreamParameters> map = this.streams;
        synchronized (map) {
            RequestStreamParameters<T, R> value = this.streams.put(path, new RequestStreamParameters<T, R>(requestType, responseDataType, requestStream));
            if (value == null) {
                return null;
            }
            return value.getRequestStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, R> RequestStreamParameters<T, R> getStreamToNotify(String path) {
        Map<String, RequestStreamParameters> map = this.streams;
        synchronized (map) {
            return this.streams.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Messaging.RequestStream<?, ?> remove(String path) {
        Map<String, RequestStreamParameters> map = this.streams;
        synchronized (map) {
            RequestStreamParameters value = this.streams.remove(path);
            if (value == null) {
                return null;
            }
            return value.getRequestStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardAll() {
        HashSet currentStreams;
        Map<String, RequestStreamParameters> map = this.streams;
        synchronized (map) {
            currentStreams = new HashSet();
            for (RequestStreamParameters values : this.streams.values()) {
                currentStreams.add(values.getRequestStream());
            }
            this.streams.clear();
        }
        for (Messaging.RequestStream requestStream : currentStreams) {
            requestStream.onError(ErrorReason.SESSION_CLOSED);
        }
    }
}

