/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.session;

import com.pushtechnology.diffusion.client.internal.session.ClientSessionLocks;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.impl.SessionLockAcquisition;
import com.pushtechnology.diffusion.client.session.impl.SessionLockRequest;
import com.pushtechnology.diffusion.client.session.impl.SessionLockRequestCancellation;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ResponseHandler;
import com.pushtechnology.diffusion.util.concurrent.threads.WaitProtectedCompletableFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ClientSessionLocksImpl
implements ClientSessionLocks {
    private final ServiceReference<SessionLockRequest, SessionLockAcquisition> acquireLock;
    private final ServiceReference<SessionLockRequestCancellation, Void> cancelLockRequest;
    private final ServiceReference<SessionLockAcquisition, Boolean> releaseLock;
    @GuardedBy(value="Content guarded by locks")
    private final Map<String, SessionLockImpl> locks = new HashMap<String, SessionLockImpl>();
    private final AtomicLong nextRequestId = new AtomicLong();
    private volatile ConversationId failoverDetectionCid = null;

    public ClientSessionLocksImpl(InternalSession internalSession) {
        ServiceLocator serviceLocator = internalSession.getServiceLocator();
        this.acquireLock = serviceLocator.obtainService(CommonServices.ACQUIRE_SESSION_LOCK);
        this.cancelLockRequest = serviceLocator.obtainService(CommonServices.CANCEL_ACQUIRE_SESSION_LOCK);
        this.releaseLock = serviceLocator.obtainService(CommonServices.RELEASE_SESSION_LOCK);
        internalSession.addListener((session, oldState, newState) -> {
            if (newState == Session.State.RECOVERING_RECONNECT) {
                Map<String, SessionLockImpl> map = this.locks;
                synchronized (map) {
                    for (SessionLockImpl lock : this.locks.values()) {
                        if (lock.getScope() != Session.SessionLockScope.UNLOCK_ON_CONNECTION_LOSS) continue;
                        lock.setReleased();
                    }
                }
                this.failoverDetectionCid = internalSession.getConversations().newConversation(new ResponseHandler(){

                    @Override
                    public boolean onResponse(ConversationId id, Object response) {
                        return true;
                    }

                    @Override
                    public void onDiscard(ConversationId id, Throwable reason) {
                        ClientSessionLocksImpl.this.releaseAllLocks();
                    }
                });
            } else if (newState == Session.State.CONNECTED_ACTIVE) {
                if (this.failoverDetectionCid != null) {
                    internalSession.getConversations().respondIfPresent(this.failoverDetectionCid, null);
                    this.failoverDetectionCid = null;
                }
            } else if (newState.isClosed()) {
                this.releaseAllLocks();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllLocks() {
        Map<String, SessionLockImpl> map = this.locks;
        synchronized (map) {
            for (SessionLockImpl lock : this.locks.values()) {
                lock.setReleased();
            }
            this.locks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Session.SessionLock> lock(String lockName, Session.SessionLockScope scope) {
        Session.SessionLock existingLock;
        Map<String, SessionLockImpl> map = this.locks;
        synchronized (map) {
            existingLock = this.locks.get(lockName);
        }
        if (existingLock != null && existingLock.isOwned()) {
            return CompletableFuture.completedFuture(existingLock);
        }
        long requestId = this.nextRequestId.getAndIncrement();
        WaitProtectedCompletableFuture<Session.SessionLock> result = new WaitProtectedCompletableFuture<Session.SessionLock>();
        this.acquireLock.sendCommand(new SessionLockRequest(lockName, requestId, scope)).whenComplete((acquisition, e) -> {
            if (acquisition != null) {
                Session.SessionLock newLock = this.handleAcquisistion(lockName, (SessionLockAcquisition)acquisition);
                if (!result.complete(newLock)) {
                    newLock.unlock();
                }
            } else {
                result.completeExceptionally((Throwable)e);
            }
        });
        ((CompletableFuture)result).whenComplete((ignoredResult, ignoredExcepton) -> {
            if (result.isCancelled()) {
                this.cancelLockRequest.sendCommand(new SessionLockRequestCancellation(lockName, requestId));
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session.SessionLock handleAcquisistion(String lockName, SessionLockAcquisition acquisition) {
        Map<String, SessionLockImpl> map = this.locks;
        synchronized (map) {
            SessionLockImpl sessionLock;
            SessionLockImpl old = this.locks.get(lockName);
            if (old != null) {
                if (old.getSequence() != acquisition.getSequence()) {
                    old.setReleased();
                    sessionLock = new SessionLockImpl(acquisition);
                    this.locks.put(lockName, sessionLock);
                } else {
                    sessionLock = old;
                }
            } else {
                sessionLock = new SessionLockImpl(acquisition);
                this.locks.put(lockName, sessionLock);
            }
            return sessionLock;
        }
    }

    private final class SessionLockImpl
    implements Session.SessionLock {
        private final SessionLockAcquisition acquisition;
        private final AtomicBoolean owned = new AtomicBoolean(true);

        SessionLockImpl(SessionLockAcquisition acquisition) {
            this.acquisition = acquisition;
        }

        @Override
        public String getName() {
            return this.acquisition.getLockName();
        }

        @Override
        public long getSequence() {
            return this.acquisition.getSequence();
        }

        @Override
        public boolean isOwned() {
            return this.owned.get();
        }

        @Override
        public Session.SessionLockScope getScope() {
            return this.acquisition.getScope();
        }

        @Override
        public CompletableFuture<Boolean> unlock() {
            if (this.owned.compareAndSet(true, false)) {
                return ClientSessionLocksImpl.this.releaseLock.sendCommand(this.acquisition).whenComplete((r, e) -> {
                    Map<String, SessionLockImpl> map = ClientSessionLocksImpl.this.locks;
                    synchronized (map) {
                        String name = this.acquisition.getLockName();
                        if (ClientSessionLocksImpl.this.locks.get(name) == this) {
                            ClientSessionLocksImpl.this.locks.remove(name);
                        }
                    }
                });
            }
            return CompletableFuture.completedFuture(false);
        }

        void setReleased() {
            this.owned.set(false);
        }

        public int hashCode() {
            return this.acquisition.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SessionLockImpl)) {
                return false;
            }
            SessionLockImpl other = (SessionLockImpl)o;
            return this.acquisition.equals(other.acquisition);
        }

        public String toString() {
            return "SessionLock[name=" + this.getName() + ", sequence=" + this.getSequence() + ", scope=" + String.valueOf((Object)this.getScope()) + ", owned=" + this.isOwned() + "]";
        }
    }
}

