/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.services;

import com.pushtechnology.diffusion.client.features.control.topics.TopicNotifications;
import com.pushtechnology.diffusion.client.internal.services.AbstractRegistration;
import com.pushtechnology.diffusion.client.internal.services.InternalRegistration;
import com.pushtechnology.diffusion.client.internal.services.MutableServiceRegistry;
import com.pushtechnology.diffusion.client.internal.services.TopicNotificationListenerRegistration;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.commands.control.topics.InternalNotificationEvent;
import com.pushtechnology.diffusion.command.commands.control.topics.TopicNotificationSelection;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.topics.selectors.TopicSelectorParser;
import com.pushtechnology.diffusion.util.concurrent.threads.WaitProtectedCompletableFuture;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

public class TopicNotificationListenerRegistrationImpl
extends AbstractRegistration
implements TopicNotificationListenerRegistration {
    private final TopicSelectorParser parser;

    public TopicNotificationListenerRegistrationImpl(InternalSession internalSession, MutableServiceRegistry registry, TopicSelectorParser parser) {
        super(internalSession);
        this.parser = parser;
        registry.add(CommonServices.TOPIC_NOTIFICATION_EVENTS, (session, event, callback) -> {
            callback.respond(null);
            internalSession.getConversations().respondIfPresent(event.getCid(), event);
        });
        registry.add(CommonServices.TOPIC_DESCENDANT_EVENTS, (session, event, callback) -> {
            callback.respond(null);
            internalSession.getConversations().respondIfPresent(event.getCid(), event);
        });
    }

    @Override
    public CompletableFuture<TopicNotifications.NotificationRegistration> registerListener(final TopicNotifications.TopicNotificationListener listener) {
        final InternalSession internalSession = this.getInternalSession();
        final WaitProtectedCompletableFuture<TopicNotifications.NotificationRegistration> future = new WaitProtectedCompletableFuture<TopicNotifications.NotificationRegistration>();
        AbstractRegistration.HandlerAdapter<InternalNotificationEvent> apiHandler = new AbstractRegistration.HandlerAdapter<InternalNotificationEvent>(){

            @Override
            public void activateHandler(InternalRegistration registration) {
                future.complete(new NotificationRegistrationImpl(internalSession, registration, TopicNotificationListenerRegistrationImpl.this.parser));
            }

            @Override
            public void respondToHandler(InternalNotificationEvent event) {
                if (event.isDescendantEvent()) {
                    listener.onDescendantNotification(event.getTopicPath(), event.getEventType());
                } else {
                    listener.onTopicNotification(event.getTopicPath(), event.getTopicSpecification(), event.getEventType());
                }
            }

            @Override
            public void onError(Throwable reason) {
                if (!future.completeExceptionally(ErrorReasonException.toApiException(reason))) {
                    listener.onError(ErrorReasonException.localExceptionToErrorReason(reason));
                }
            }

            @Override
            public void closeHandler() {
                listener.onClose();
            }

            @Override
            public void onSessionClosed(Throwable reason) {
                listener.onError(ErrorReasonException.localExceptionToErrorReason(reason));
            }
        };
        ConversationId cid = this.createConversation(apiHandler, internalSession.getServiceLocator().obtainService(CommonServices.TOPIC_NOTIFICATION_DEREGISTRATION)::sendCommand);
        internalSession.getConversations().respondIfPresent(cid, (Object)AbstractRegistration.ResponseHandlerState.ACTIVE);
        return future;
    }

    @Immutable
    private static class NotificationRegistrationImpl
    implements TopicNotifications.NotificationRegistration {
        private final ConversationId cid;
        private final InternalRegistration registration;
        private final TopicSelectorParser parser;
        private final ServiceReference<TopicNotificationSelection, Void> selectionService;
        private final ServiceReference<TopicNotificationSelection, Void> deselectionService;

        NotificationRegistrationImpl(InternalSession internalSession, InternalRegistration registration, TopicSelectorParser parser) {
            this.cid = registration.getConversationId();
            this.registration = registration;
            this.parser = parser;
            this.selectionService = internalSession.getServiceLocator().obtainService(CommonServices.TOPIC_NOTIFICATION_SELECTION);
            this.deselectionService = internalSession.getServiceLocator().obtainService(CommonServices.TOPIC_NOTIFICATION_DESELECTION);
        }

        @Override
        public CompletableFuture<?> close() {
            return this.registration.close().thenApply(Functions.identity());
        }

        @Override
        public CompletableFuture<?> select(TopicSelector selector) {
            return this.selectionService.sendCommand(new TopicNotificationSelection(this.cid, Objects.requireNonNull(selector, "topic selector").getExpression())).thenApply(Functions.identity());
        }

        @Override
        public CompletableFuture<?> select(String selector) {
            return this.selectionService.sendCommand(new TopicNotificationSelection(this.cid, this.parser.parse(Objects.requireNonNull(selector, "topic selector")).getExpression())).thenApply(Functions.identity());
        }

        @Override
        public CompletableFuture<?> deselect(TopicSelector selector) {
            return this.deselectionService.sendCommand(new TopicNotificationSelection(this.cid, Objects.requireNonNull(selector, "topic selector").getExpression())).thenApply(Functions.identity());
        }

        @Override
        public CompletableFuture<?> deselect(String selector) {
            return this.deselectionService.sendCommand(new TopicNotificationSelection(this.cid, this.parser.parse(Objects.requireNonNull(selector, "topic selector")).getExpression())).thenApply(Functions.identity());
        }
    }
}

