/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.services;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.Messaging;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.internal.streams.RequestStreamParameters;
import com.pushtechnology.diffusion.client.internal.streams.RequestStreamRegistry;
import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.commands.control.client.MessagingResponse;
import com.pushtechnology.diffusion.command.commands.send.MessagingSendRequest;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.logs.i18n.I18nUtils;

public final class RequestResponseService
implements CommandService<MessagingSendRequest, MessagingResponse, InternalSession> {
    private static final I18nLogger LOG = I18nLogger.getLogger(RequestResponseService.class);
    private final RequestStreamRegistry registry;

    public RequestResponseService(RequestStreamRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void onRequest(InternalSession session, MessagingSendRequest request, CommandService.ServiceCallback<MessagingResponse> callback) {
        this.onRequestReceivedInternal(callback, session, request.getPath(), request.getDataType(), request.getRequest());
    }

    private <T, R> void onRequestReceivedInternal(CommandService.ServiceCallback<MessagingResponse> callback, InternalSession session, String path, DataType<?> dataType, IBytes request) {
        RequestStreamParameters value = this.registry.getStreamToNotify(path);
        if (value == null) {
            LOG.debug("There are no request streams registered to path {}", (Object)path);
            callback.fail(ErrorReason.UNHANDLED_MESSAGE, "Session " + String.valueOf(session.getSessionId()) + " has no registered streams for message sent to path '" + path + "'");
            return;
        }
        Class requestType = value.getRequestType();
        DataType responseDataType = value.getResponseDataType();
        Messaging.RequestStream requestStream = value.getRequestStream();
        ResponderImpl responder = new ResponderImpl(callback, responseDataType);
        if (dataType.canReadAs(requestType)) {
            Object requestData;
            try {
                requestData = dataType.readAs(requestType, request);
            }
            catch (InvalidDataException ex) {
                I18nLogger.Translation translation = I18nUtils.formatMessage("MESSAGING_REQUEST_CANNOT_CONVERT_VALUE", requestType, path, requestStream);
                LOG.error(translation, (Throwable)ex);
                callback.fail(ErrorReason.INVALID_DATA, translation.getText());
                return;
            }
            try {
                requestStream.onRequest(path, requestData, responder);
            }
            catch (RuntimeException ex) {
                LOG.error("MESSAGING_REQUEST_EXCEPTION", (Throwable)ex);
                callback.fail(ErrorReason.CALLBACK_EXCEPTION, ex.getMessage());
            }
        } else {
            I18nLogger.Translation translation = I18nUtils.formatMessage("MESSAGING_REQUEST_INCOMPATIBLE", dataType, path, requestStream);
            LOG.debug(translation);
            callback.fail(ErrorReason.INCOMPATIBLE_DATATYPE, translation.getText());
        }
    }

    private static final class ResponderImpl<R>
    implements Messaging.RequestStream.Responder<R> {
        private final CommandService.ServiceCallback<MessagingResponse> callback;
        private final DataType<? super R> responseDataType;

        private ResponderImpl(CommandService.ServiceCallback<MessagingResponse> callback, DataType<? super R> responseDataType) {
            this.callback = callback;
            this.responseDataType = responseDataType;
        }

        @Override
        public void respond(R response) {
            IBytes responseData = IBytes.toIBytes(this.responseDataType.toBytes(response));
            MessagingResponse messagingResponse = new MessagingResponse(this.responseDataType, responseData);
            this.callback.respond(messagingResponse);
        }

        @Override
        public void reject(String message) {
            this.callback.fail(ErrorReasonException.REJECTED_REQUEST, message);
        }
    }
}

