/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.services;

import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.internal.services.AbstractRegistration;
import com.pushtechnology.diffusion.client.internal.services.MissingTopicHandlerRegistration;
import com.pushtechnology.diffusion.client.internal.services.MutableServiceRegistry;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.commands.control.topics.MissingTopicRequest;
import com.pushtechnology.diffusion.command.receiver.AbstractCommandService;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.control.ControlGroup;
import com.pushtechnology.diffusion.control.registration.TopicControlRegistrationParameters;
import com.pushtechnology.diffusion.conversation.ConversationSet;
import com.pushtechnology.diffusion.conversation.NoSuchConversationException;
import com.pushtechnology.diffusion.topics.selectors.TopicSelectorParser;
import com.pushtechnology.diffusion.util.concurrent.threads.WaitProtectedCompletableFuture;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class MissingTopicHandlerRegistrationImpl
extends AbstractRegistration
implements MissingTopicHandlerRegistration {
    public MissingTopicHandlerRegistrationImpl(InternalSession internalSession, MutableServiceRegistry serviceRegistry, TopicSelectorParser topicSelectorParser) {
        super(internalSession);
        serviceRegistry.add(CommonServices.MISSING_TOPIC, new MissingTopicsService(topicSelectorParser));
    }

    @Override
    public CompletableFuture<Registration> register(String topicPath, TopicControl.MissingTopicNotificationStream stream) {
        WaitProtectedCompletableFuture<Registration> result = new WaitProtectedCompletableFuture<Registration>();
        this.registerTopicControlHandler(new TopicControlRegistrationParameters(CommonServices.MISSING_TOPIC, ControlGroup.DEFAULT, topicPath), new MissingTopicNotificationStreamAdapter(result, stream));
        return result;
    }

    private static final class MissingTopicsService
    extends AbstractCommandService<MissingTopicRequest, Boolean, InternalSession> {
        private final TopicSelectorParser topicSelectorParser;

        MissingTopicsService(TopicSelectorParser topicSelectorParser) {
            this.topicSelectorParser = topicSelectorParser;
        }

        @Override
        public void safeOnRequest(InternalSession internalSession, MissingTopicRequest request, CommandService.ServiceCallback<Boolean> callback) throws NoSuchConversationException {
            TopicSelector topicSelector = this.topicSelectorParser.parse(request.getSelector());
            ConversationSet conversations = internalSession.getConversations();
            callback.respond(true);
            conversations.respond(request.getContext(), new MissingTopicNotificationImpl(topicSelector, request.getSessionProperties(), request.getServers()));
        }
    }

    private static final class MissingTopicNotificationStreamAdapter
    extends AbstractRegistration.AbstractHandlerAdapter<TopicControl.MissingTopicNotification> {
        private final TopicControl.MissingTopicNotificationStream stream;

        MissingTopicNotificationStreamAdapter(WaitProtectedCompletableFuture<Registration> registrationFuture, TopicControl.MissingTopicNotificationStream stream) {
            super(registrationFuture);
            this.stream = stream;
        }

        @Override
        public void respondToHandler(TopicControl.MissingTopicNotification response) {
            this.stream.onMissingTopic(response);
        }

        @Override
        protected void reportPostRegistrationError(Throwable reason) {
            this.stream.onError(ErrorReasonException.localExceptionToErrorReason(reason));
        }

        @Override
        public void closeHandler() {
            this.stream.onClose();
        }

        public String toString() {
            return this.stream.toString();
        }
    }

    static final class MissingTopicNotificationImpl
    implements TopicControl.MissingTopicNotification {
        private final TopicSelector topicSelector;
        private final Map<String, String> sessionProperties;
        private final List<String> serverNames;

        MissingTopicNotificationImpl(TopicSelector topicSelector, Map<String, String> sessionProperties, List<String> serverNames) {
            this.topicSelector = topicSelector;
            this.sessionProperties = sessionProperties;
            this.serverNames = serverNames;
        }

        @Override
        public Map<String, String> getSessionProperties() {
            return this.sessionProperties;
        }

        @Override
        public TopicSelector getTopicSelector() {
            return this.topicSelector;
        }

        @Override
        public List<String> getServerNames() {
            return this.serverNames;
        }

        public int hashCode() {
            return Objects.hash(this.topicSelector, this.sessionProperties, this.serverNames);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MissingTopicNotificationImpl)) {
                return false;
            }
            MissingTopicNotificationImpl other = (MissingTopicNotificationImpl)obj;
            return this.topicSelector.equals(other.topicSelector) && this.sessionProperties.equals(other.sessionProperties) && this.serverNames.equals(other.serverNames);
        }

        public String toString() {
            return "MissingTopicNotification [Topic Selector=" + String.valueOf(this.topicSelector) + ", Session Properties=" + String.valueOf(this.sessionProperties) + ", Server Names=" + String.valueOf(this.serverNames) + "]";
        }
    }
}

