/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.services;

import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.features.control.clients.AuthenticationControl;
import com.pushtechnology.diffusion.client.internal.services.AbstractRegistration;
import com.pushtechnology.diffusion.client.internal.services.AuthenticatorRegistration;
import com.pushtechnology.diffusion.client.internal.services.MutableServiceRegistry;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.security.authentication.Authenticator;
import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.commands.control.authentication.AuthenticatorRequest;
import com.pushtechnology.diffusion.command.commands.control.authentication.AuthenticatorResponse;
import com.pushtechnology.diffusion.command.receiver.AbstractCommandService;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.control.ControlGroup;
import com.pushtechnology.diffusion.control.registration.AuthenticatorRegistrationParameters;
import com.pushtechnology.diffusion.control.registration.AuthenticatorRegistrationRequest;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.NoSuchConversationException;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.java7.Streams;
import com.pushtechnology.diffusion.util.concurrent.threads.WaitProtectedCompletableFuture;
import com.pushtechnology.diffusion.utils.PropertyUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.jcip.annotations.Immutable;

@Immutable
public final class AuthenticatorRegistrationImpl
extends AbstractRegistration
implements AuthenticatorRegistration {
    public AuthenticatorRegistrationImpl(InternalSession internalSession, MutableServiceRegistry serviceRegistry) {
        super(internalSession);
        serviceRegistry.add(CommonServices.AUTHENTICATOR, new AuthenticatorService());
    }

    @Override
    public CompletableFuture<Registration> register(String name, AuthenticationControl.ControlAuthenticator authenticator) {
        InternalSession internalSession = this.getInternalSession();
        ServiceReference<AuthenticatorRegistrationRequest, Void> registrationService = internalSession.getServiceLocator().obtainService(CommonServices.AUTHENTICATOR_REGISTRATION);
        ServiceReference<AuthenticatorRegistrationParameters, Void> deregistration = internalSession.getServiceLocator().obtainService(CommonServices.AUTHENTICATOR_DEREGISTRATION);
        AuthenticatorRegistrationParameters parameters = new AuthenticatorRegistrationParameters(CommonServices.AUTHENTICATOR, ControlGroup.DEFAULT, name);
        WaitProtectedCompletableFuture<Registration> result = new WaitProtectedCompletableFuture<Registration>();
        AuthenticatorAdapter adapter = new AuthenticatorAdapter(authenticator, result);
        ConversationId cid = this.createConversation(adapter, ignored -> deregistration.sendCommand(parameters));
        registrationService.sendCommand(new AuthenticatorRegistrationRequest(parameters, cid), new AbstractRegistration.RegistrationReferenceCallback(this, cid));
        return result.thenApply(Functions.identity());
    }

    private static final class AuthenticatorService
    extends AbstractCommandService<AuthenticatorRequest, AuthenticatorResponse, InternalSession> {
        private AuthenticatorService() {
        }

        @Override
        public void safeOnRequest(InternalSession internalSession, AuthenticatorRequest request, CommandService.ServiceCallback<AuthenticatorResponse> callback) throws NoSuchConversationException {
            internalSession.getConversations().respond(request.getContext(), new Response(request, callback));
        }
    }

    private final class AuthenticatorAdapter
    extends AbstractRegistration.AbstractHandlerAdapter<Response> {
        private final AuthenticationControl.ControlAuthenticator authenticator;

        private AuthenticatorAdapter(AuthenticationControl.ControlAuthenticator authenticator, WaitProtectedCompletableFuture<Registration> registrationFuture) {
            super(registrationFuture);
            this.authenticator = authenticator;
        }

        @Override
        public void respondToHandler(Response response) {
            AuthenticatorRequest request = response.getRequest();
            final CommandService.ServiceCallback serviceCallback = response.getCallback();
            final Map<String, String> sessionProperties = request.getSessionProperties();
            this.authenticator.authenticate(request.getPrincipal(), request.getCredentials(), new HashMap<String, String>(sessionProperties), request.getProposedProperties(), new Authenticator.Callback(){

                @Override
                public void deny() {
                    serviceCallback.respond(AuthenticatorResponse.DENY);
                }

                @Override
                public void allow(Map<String, String> properties) {
                    serviceCallback.respond(AuthenticatorResponse.allow(Streams.stream(properties.entrySet()).filter(e -> !PropertyUtils.isFixedSessionProperty((String)e.getKey()) || !((String)e.getValue()).equals(sessionProperties.get(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
                }

                @Override
                public void allow() {
                    serviceCallback.respond(AuthenticatorResponse.allow(Collections.emptyMap()));
                }

                @Override
                public void abstain() {
                    serviceCallback.respond(AuthenticatorResponse.ABSTAIN);
                }
            });
        }

        @Override
        public void closeHandler() {
            this.authenticator.onClose();
        }

        @Override
        protected void reportPostRegistrationError(Throwable reason) {
            this.authenticator.onError(ErrorReasonException.localExceptionToErrorReason(reason));
        }

        public String toString() {
            return this.authenticator.toString();
        }
    }

    private static final class Response
    extends AbstractRegistration.ServiceCallbackResponse<AuthenticatorResponse> {
        private final AuthenticatorRequest request;

        Response(AuthenticatorRequest request, CommandService.ServiceCallback<AuthenticatorResponse> callback) {
            super(callback);
            this.request = request;
        }

        AuthenticatorRequest getRequest() {
            return this.request;
        }
    }
}

