/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.services;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.features.ErrorReportsException;
import com.pushtechnology.diffusion.client.internal.services.InternalRegistration;
import com.pushtechnology.diffusion.client.internal.services.RegisteredHandlerException;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.internal.session.SessionErrorImpl;
import com.pushtechnology.diffusion.client.session.SessionClosedException;
import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.command.sender.ReferenceCallback;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.control.registration.ControlRegistrationParameters;
import com.pushtechnology.diffusion.control.registration.ControlRegistrationRequestImpl;
import com.pushtechnology.diffusion.control.registration.TopicControlRegistrationParameters;
import com.pushtechnology.diffusion.control.registration.TopicControlRegistrationRequest;
import com.pushtechnology.diffusion.conversation.AbstractResponseHandler;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationSet;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.types.ErrorReportList;
import com.pushtechnology.diffusion.util.concurrent.threads.WaitProtectedCompletableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@Immutable
abstract class AbstractRegistration {
    private static final Logger LOG = I18nLogger.getLogger(AbstractRegistration.class);
    private final InternalSession internalSession;

    AbstractRegistration(InternalSession internalSession) {
        this.internalSession = internalSession;
    }

    protected final InternalSession getInternalSession() {
        return this.internalSession;
    }

    protected final <T> void registerServerControlHandler(ControlRegistrationParameters parameters, HandlerAdapter<T> apiAdapter) {
        ServiceReference<ControlRegistrationRequestImpl, Void> registration = this.internalSession.getServiceLocator().obtainService(CommonServices.SERVER_CONTROL_REGISTRATION);
        ServiceReference<ControlRegistrationParameters, Void> deregistration = this.internalSession.getServiceLocator().obtainService(CommonServices.SERVER_CONTROL_DEREGISTRATION);
        ConversationId cid = this.createConversation(apiAdapter, x -> deregistration.sendCommand(parameters));
        registration.sendCommand(new ControlRegistrationRequestImpl(parameters, cid), new RegistrationReferenceCallback(cid));
    }

    protected final <T> void registerTopicControlHandler(TopicControlRegistrationParameters parameters, HandlerAdapter<T> apiAdapter) {
        ServiceReference<TopicControlRegistrationRequest, Void> registration = this.internalSession.getServiceLocator().obtainService(CommonServices.TOPIC_CONTROL_REGISTRATION);
        ServiceReference<TopicControlRegistrationParameters, Void> deregistration = this.internalSession.getServiceLocator().obtainService(CommonServices.TOPIC_CONTROL_DEREGISTRATION);
        ConversationId cid = this.createConversation(apiAdapter, x -> deregistration.sendCommand(parameters));
        registration.sendCommand(new TopicControlRegistrationRequest(parameters, cid), new RegistrationReferenceCallback(cid));
    }

    protected final <T> ConversationId createConversation(HandlerAdapter<T> apiAdapter, Function<ConversationId, CompletableFuture<Void>> deregister) {
        ConversationHandler<T> handler = new ConversationHandler<T>(apiAdapter, deregister);
        return this.getInternalSession().getConversations().newConversation(handler::onOpen, handler);
    }

    protected static interface HandlerAdapter<T> {
        public void activateHandler(InternalRegistration var1);

        public void respondToHandler(T var1);

        public void closeHandler();

        public void onError(Throwable var1);

        public void onSessionClosed(Throwable var1);
    }

    @ThreadSafe
    protected class RegistrationReferenceCallback
    implements ReferenceCallback<Void> {
        private final ConversationId cid;

        RegistrationReferenceCallback(ConversationId cid) {
            this.cid = cid;
        }

        @Override
        public final void onResponse(Void registered) {
            AbstractRegistration.this.internalSession.getConversations().respondIfPresent(this.cid, (Object)ResponseHandlerState.ACTIVE);
        }

        @Override
        public final void onFailure(Throwable reason) {
            AbstractRegistration.this.internalSession.getConversations().discard(this.cid, reason);
        }
    }

    private final class ConversationHandler<T>
    extends AbstractResponseHandler<Object> {
        private final HandlerAdapter<T> adapter;
        private final Function<ConversationId, CompletableFuture<Void>> deregister;
        private InternalRegistration registration;
        private volatile ResponseHandlerState state;

        ConversationHandler(HandlerAdapter<T> adapter, Function<ConversationId, CompletableFuture<Void>> deregister) {
            super(Object.class);
            this.state = ResponseHandlerState.REGISTERING;
            this.adapter = adapter;
            this.deregister = deregister;
        }

        void onOpen(final ConversationId cid) {
            this.registration = new InternalRegistration(){

                @Override
                public ConversationId getConversationId() {
                    return cid;
                }

                @Override
                public CompletableFuture<?> close() {
                    return ((CompletableFuture)ConversationHandler.this.deregister.apply(cid).whenComplete((ignored, reason) -> {
                        ConversationSet conversations = AbstractRegistration.this.internalSession.getConversations();
                        if (reason == null) {
                            conversations.respondIfPresent(cid, (Object)ResponseHandlerState.CLOSED);
                        } else {
                            conversations.discard(cid, (Throwable)reason);
                        }
                    })).thenApply(Functions.identity());
                }
            };
        }

        @Override
        public boolean onTypedResponse(ConversationId id, Object response) {
            block8: {
                if (response == ResponseHandlerState.CLOSED) {
                    try {
                        this.adapter.closeHandler();
                    }
                    catch (Exception e) {
                        LOG.error("REGISTERED_HANDLER_EXCEPTION", (Object)this.adapter, (Object)e);
                    }
                    this.state = ResponseHandlerState.CLOSED;
                    return true;
                }
                try {
                    if (response == ResponseHandlerState.ACTIVE) {
                        assert (this.state == ResponseHandlerState.REGISTERING) : this.state;
                        this.adapter.activateHandler(this.registration);
                        this.state = ResponseHandlerState.ACTIVE;
                    } else {
                        this.adapter.respondToHandler(response);
                    }
                }
                catch (Exception e) {
                    LOG.error("REGISTERED_HANDLER_EXCEPTION", (Object)this.adapter, (Object)e);
                    AbstractRegistration.this.internalSession.getConversations().discard(id, new RegisteredHandlerException(e));
                    this.deregister.apply(id).exceptionally(ex -> {
                        LOG.debug("Failed to deregister {} with the server", (Object)this.adapter, ex);
                        return null;
                    });
                    if (!(response instanceof ServiceCallbackResponse)) break block8;
                    ((ServiceCallbackResponse)response).fail(ErrorReason.CALLBACK_EXCEPTION, e.getMessage());
                }
            }
            return false;
        }

        @Override
        public void onDiscard(ConversationId id, Throwable reason) {
            try {
                if (this.state != ResponseHandlerState.REGISTERING && reason instanceof SessionClosedException) {
                    this.adapter.onSessionClosed(reason);
                } else {
                    this.adapter.onError(reason);
                }
            }
            catch (Exception e) {
                LOG.error("REGISTERED_HANDLER_EXCEPTION", (Object)this.adapter, (Object)e);
            }
            this.state = ResponseHandlerState.CLOSED;
        }
    }

    protected static abstract class ServiceCallbackResponse<T> {
        private final CommandService.ServiceCallback<T> callback;

        ServiceCallbackResponse(CommandService.ServiceCallback<T> callback) {
            this.callback = callback;
        }

        CommandService.ServiceCallback<T> getCallback() {
            return this.callback;
        }

        void fail(ErrorReason errorReason, String description) {
            try {
                this.callback.fail(errorReason, description);
            }
            catch (IllegalStateException e) {
                LOG.trace("{} already completed", (Object)this.callback, (Object)e);
            }
        }
    }

    protected static enum ResponseHandlerState {
        REGISTERING,
        ACTIVE,
        CLOSED;

    }

    protected abstract class AbstractLegacyHandlerAdapter<T>
    implements HandlerAdapter<T> {
        protected AbstractLegacyHandlerAdapter() {
        }

        @Override
        public final void onError(Throwable reason) {
            AbstractRegistration.this.getInternalSession().getErrorHandler().notifyError(new SessionErrorImpl(reason.toString(), reason));
            this.closeHandler();
        }

        @Override
        public final void onSessionClosed(Throwable reason) {
            this.closeHandler();
        }
    }

    protected static abstract class AbstractCallbackHandlerAdapter<T>
    implements HandlerAdapter<T> {
        protected AbstractCallbackHandlerAdapter() {
        }

        @Override
        public final void onSessionClosed(Throwable reason) {
            this.onError(reason);
        }
    }

    protected static abstract class AbstractHandlerAdapter<T>
    implements HandlerAdapter<T> {
        private final CompletableFuture<Registration> registrationFuture;

        protected AbstractHandlerAdapter(WaitProtectedCompletableFuture<Registration> registrationFuture) {
            this.registrationFuture = registrationFuture;
        }

        @Override
        public final void activateHandler(InternalRegistration registration) {
            this.registrationFuture.complete(registration);
        }

        @Override
        public final void onError(Throwable reason) {
            if (!this.registrationFuture.completeExceptionally(ErrorReasonException.toApiException(reason))) {
                this.reportPostRegistrationError(reason);
            }
        }

        @Override
        public final void onSessionClosed(Throwable reason) {
            this.reportPostRegistrationError(reason);
        }

        protected abstract void reportPostRegistrationError(Throwable var1);
    }

    @ThreadSafe
    protected class RegistrationWithErrorsReferenceCallback
    implements ReferenceCallback<ErrorReportList> {
        private final ConversationId cid;
        private final String message;

        RegistrationWithErrorsReferenceCallback(ConversationId cid, String message) {
            this.cid = cid;
            this.message = message;
        }

        @Override
        public final void onResponse(ErrorReportList registered) {
            if (ErrorReportList.SUCCESS.equals(registered)) {
                AbstractRegistration.this.internalSession.getConversations().respondIfPresent(this.cid, (Object)ResponseHandlerState.ACTIVE);
            } else {
                ErrorReportsException ex = new ErrorReportsException(this.message, registered.getErrors());
                AbstractRegistration.this.internalSession.getConversations().discard(this.cid, ex);
            }
        }

        @Override
        public final void onFailure(Throwable reason) {
            AbstractRegistration.this.internalSession.getConversations().discard(this.cid, reason);
        }
    }
}

