/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.routing;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.client.internal.routing.DataTypeTopicCacheEntry;
import com.pushtechnology.diffusion.client.internal.routing.StreamProxy;
import com.pushtechnology.diffusion.client.internal.routing.TimeSeriesEventStreamProxy;
import com.pushtechnology.diffusion.client.internal.routing.ValueStreamProxy;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.threads.InboundThreadOnly;
import com.pushtechnology.diffusion.timeseries.datatype.TimeSeriesEventDataType;

@InboundThreadOnly
final class TimeSeriesTopicCacheEntry<T>
extends DataTypeTopicCacheEntry<TimeSeries.Event<T>> {
    private final DataType<T> eventValueType;

    private static boolean isCompatibleStream(DataType<?> eventValueType, StreamProxy streamProxy, TopicSpecification specification) {
        if (streamProxy instanceof TimeSeriesEventStreamProxy) {
            return specification.getType() == TopicType.TIME_SERIES && TimeSeriesTopicCacheEntry.isCompatibleTimeSeriesEventStreamProxy(eventValueType, (TimeSeriesEventStreamProxy)streamProxy);
        }
        return true;
    }

    private static <V> boolean isCompatibleTimeSeriesEventStreamProxy(DataType<?> eventValueType, TimeSeriesEventStreamProxy<V> streamProxy) {
        return eventValueType.canReadAs(streamProxy.getEventValueClass());
    }

    TimeSeriesTopicCacheEntry(String topicPath, TopicSpecification topicSpecification, DataType<T> eventValueType, ImmutableSet<StreamProxy> unfilteredProxies) {
        super(topicPath, topicSpecification, TimeSeriesEventDataType.create(eventValueType), unfilteredProxies.without(s -> !TimeSeriesTopicCacheEntry.isCompatibleStream(eventValueType, s, topicSpecification)));
        this.eventValueType = eventValueType;
    }

    @Override
    protected <V> boolean isCompatibleStream(ValueStreamProxy<V> streamProxy, TopicSpecification specification) {
        if (streamProxy instanceof TimeSeriesEventStreamProxy) {
            return TimeSeriesTopicCacheEntry.isCompatibleTimeSeriesEventStreamProxy(this.eventValueType, (TimeSeriesEventStreamProxy)streamProxy);
        }
        return super.isCompatibleStream(streamProxy, specification);
    }
}

