/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.internal.routing;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.internal.routing.StreamProxy;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.threads.InboundThreadOnly;
import org.slf4j.Logger;

@InboundThreadOnly
abstract class StreamProxyImpl
implements StreamProxy {
    private static final Logger LOG = I18nLogger.getLogger(StreamProxyImpl.class);
    private boolean closed = false;

    protected StreamProxyImpl() {
    }

    @Override
    public final void onSubscription(String topicPath, TopicSpecification specification) {
        if (!this.closed) {
            try {
                this.getStream().onSubscription(topicPath, specification);
            }
            catch (Exception ex) {
                this.logStreamException(ex);
            }
        }
    }

    @Override
    public final void onUnsubscription(String topicPath, TopicSpecification specification, Topics.UnsubscribeReason reason) {
        if (!this.closed) {
            try {
                this.getStream().onUnsubscription(topicPath, specification, reason);
            }
            catch (Exception ex) {
                this.logStreamException(ex);
            }
        }
    }

    protected final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void onError(ErrorReason reason) {
        if (!this.closed) {
            this.closed = true;
            Topics.SubscriberStream stream = this.getStream();
            try {
                stream.onError(reason);
            }
            catch (Exception e) {
                this.logStreamException(e);
            }
        }
    }

    protected final void logStreamException(Exception ex) {
        Topics.SubscriberStream stream = this.getStream();
        LOG.error("TOPICS_STREAM_EXCEPTION", (Object)stream, (Object)ex);
    }

    public final int hashCode() {
        return this.getStream().hashCode() * 17 + this.getClass().hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamProxyImpl other = (StreamProxyImpl)o;
        return this.getStream().equals(other.getStream());
    }

    public final String toString() {
        return new StringBuilder(32).append(this.getClass().getSimpleName()).append('[').append(this.getStream()).append(']').toString();
    }
}

