/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.impl;

import com.pushtechnology.diffusion.util.concurrent.threads.CommonThreadPools;
import com.pushtechnology.diffusion.util.concurrent.threads.ExecutionPool;
import com.pushtechnology.diffusion.util.concurrent.threads.ExecutionPoolImpl;
import com.pushtechnology.diffusion.util.concurrent.threads.HandleInboundQueueFull;
import com.pushtechnology.diffusion.util.concurrent.threads.LoggingScheduledThreadPoolExecutor;
import com.pushtechnology.diffusion.util.concurrent.threads.SafeScheduledExecutorService;
import com.pushtechnology.diffusion.util.concurrent.threads.ThreadFactoryImpl;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.repackaged.picocontainer.Startable;
import java.util.concurrent.ScheduledExecutorService;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ClientThreadPools
implements CommonThreadPools,
Startable {
    private final ExecutionPoolImpl inboundThreadPool;
    private volatile ScheduledExecutorService backgroundThreadPool;
    private volatile SafeScheduledExecutorService scheduledExecutorService;

    public ClientThreadPools() {
        this(ConfigurationUtils.getIntegerSystemProperty("diffusion.client.inbound_threads", 3), ConfigurationUtils.getIntegerSystemProperty("diffusion.client.inbound_thread_queue_depth", 10000));
    }

    private ClientThreadPools(int coreSize, int queueSize) {
        this.inboundThreadPool = new ExecutionPoolImpl("ClientInboundPool", coreSize, queueSize, (ExecutionPoolImpl.QueueFullHandler)HandleInboundQueueFull.INSTANCE);
    }

    @Override
    public void start() {
        String backgroundPoolName = "Client Background";
        LoggingScheduledThreadPoolExecutor executor = new LoggingScheduledThreadPoolExecutor("Client Background", 1, new ThreadFactoryImpl("Client Background"));
        this.backgroundThreadPool = executor;
        this.scheduledExecutorService = new SafeScheduledExecutorService(executor);
        this.inboundThreadPool.start();
    }

    @Override
    public void stop() {
        this.backgroundThreadPool.shutdownNow();
        this.inboundThreadPool.stop();
    }

    @Override
    public ScheduledExecutorService getBackgroundThreadPool() {
        SafeScheduledExecutorService result = this.scheduledExecutorService;
        if (result == null) {
            throw new IllegalStateException("Not started");
        }
        return result;
    }

    @Override
    public ExecutionPool getInboundThreadPool(String poolName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecutionPool getDefaultInboundThreadPool() {
        return this.inboundThreadPool;
    }
}

