/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.impl;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.timeseries.query.RangeQueryImpl;
import com.pushtechnology.diffusion.timeseries.update.TimeSeriesAppendRequest;
import com.pushtechnology.diffusion.timeseries.update.TimeSeriesEditRequest;
import com.pushtechnology.diffusion.timeseries.update.TimeSeriesTimestampAppendRequest;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class TimeSeriesImpl
extends AbstractFeature
implements TimeSeries {
    private final DataTypes dataTypes;
    private final TimeSeries.RangeQuery<Bytes> rangeQuery;
    private final ServiceReference<TimeSeriesAppendRequest, TimeSeries.EventMetadata> appendService;
    private final ServiceReference<TimeSeriesTimestampAppendRequest, TimeSeries.EventMetadata> appendTimestampService;
    private final ServiceReference<TimeSeriesEditRequest, TimeSeries.EventMetadata> editService;

    public TimeSeriesImpl(Session session, InternalSession internalSession, DataTypes dataTypes) {
        super(session, internalSession);
        this.dataTypes = dataTypes;
        ServiceLocator locator = internalSession.getServiceLocator();
        this.rangeQuery = RangeQueryImpl.createDefault(locator.obtainService(CommonServices.RANGE_QUERY));
        this.appendService = locator.obtainService(CommonServices.TIME_SERIES_APPEND);
        this.appendTimestampService = locator.obtainService(CommonServices.TIME_SERIES_TIMESTAMP_APPEND);
        this.editService = locator.obtainService(CommonServices.TIME_SERIES_EDIT);
    }

    @Override
    public TimeSeries.RangeQuery<Bytes> rangeQuery() {
        return this.rangeQuery;
    }

    @Override
    public <V> CompletableFuture<TimeSeries.EventMetadata> append(String topicPath, Class<V> valueClass, V value) {
        DataType<V> dataType = this.dataTypes.getByClass(Objects.requireNonNull(valueClass, "valueClass is null"));
        TimeSeriesAppendRequest request = new TimeSeriesAppendRequest(Objects.requireNonNull(topicPath, "topicPath is null"), dataType, IBytes.toIBytes(dataType.toBytes(value)));
        return this.appendService.sendCommand(request).thenApply(Functions.identity());
    }

    @Override
    public <V> CompletableFuture<TimeSeries.EventMetadata> append(String topicPath, Class<V> valueClass, V value, Instant timestamp) {
        DataType<V> dataType = this.dataTypes.getByClass(Objects.requireNonNull(valueClass, "valueClass is null"));
        TimeSeriesTimestampAppendRequest request = new TimeSeriesTimestampAppendRequest(Objects.requireNonNull(topicPath, "topicPath is null"), dataType, IBytes.toIBytes(dataType.toBytes(value)), Objects.requireNonNull(timestamp, "timestamp is null").toEpochMilli());
        return this.appendTimestampService.sendCommand(request).thenApply(Functions.identity());
    }

    @Override
    public <V> CompletableFuture<TimeSeries.EventMetadata> edit(String topicPath, long sequence, Class<V> valueClass, V value) {
        DataType<V> dataType = this.dataTypes.getByClass(Objects.requireNonNull(valueClass, "valueClass is null"));
        TimeSeriesEditRequest request = new TimeSeriesEditRequest(Objects.requireNonNull(topicPath, "topicPath is null"), dataType, sequence, IBytes.toIBytes(dataType.toBytes(value)));
        return this.editService.sendCommand(request).thenApply(Functions.identity());
    }
}

