/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.impl;

import com.pushtechnology.diffusion.client.features.Security;
import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.client.types.GlobalPermission;
import com.pushtechnology.diffusion.client.types.PathPermission;
import com.pushtechnology.diffusion.command.commands.security.GlobalPermissionsSet;
import com.pushtechnology.diffusion.command.commands.security.PathPermissionsSet;
import com.pushtechnology.diffusion.command.commands.security.ReauthenticateRequest;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class SecurityImpl
extends AbstractFeature
implements Security {
    private final ServiceReference<Void, GlobalPermissionsSet> listGlobalPermissionsService;
    private final ServiceReference<String, PathPermissionsSet> listPathPermissionsService;
    private final ServiceReference<ReauthenticateRequest, Boolean> reauthenticateService;

    public SecurityImpl(Session session, InternalSession internalSession) {
        super(session, internalSession);
        ServiceLocator services = internalSession.getServiceLocator();
        this.listGlobalPermissionsService = services.obtainService(CommonServices.LIST_GLOBAL_PERMISSIONS);
        this.listPathPermissionsService = services.obtainService(CommonServices.LIST_PATH_PERMISSIONS);
        this.reauthenticateService = services.obtainService(CommonServices.RE_AUTHENTICATE);
    }

    @Override
    public CompletableFuture<Set<GlobalPermission>> getGlobalPermissions() {
        return this.listGlobalPermissionsService.sendCommand(null).thenApply(GlobalPermissionsSet::getPermissions);
    }

    @Override
    public CompletableFuture<Set<PathPermission>> getPermissionsForPath(String path) {
        return this.listPathPermissionsService.sendCommand(Objects.requireNonNull(path, "path is null")).thenApply(PathPermissionsSet::getPermissions);
    }

    @Override
    public CompletableFuture<Boolean> reauthenticate(String principal, Credentials credentials, Map<String, String> properties) {
        return this.reauthenticateService.sendCommand(new ReauthenticateRequest(Objects.requireNonNull(principal, "principal is null"), Objects.requireNonNull(credentials, "credentials is null"), Objects.requireNonNull(properties, "properties is null"))).thenApply(success -> {
            if (success.booleanValue()) {
                this.internalSession().setPrincipal(principal);
            }
            return success;
        });
    }
}

