/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.impl;

import com.pushtechnology.diffusion.client.features.Pings;
import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.command.commands.ping.PingRequest;
import com.pushtechnology.diffusion.command.commands.ping.PingResponse;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.time.Stopwatch;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class PingsImpl
extends AbstractFeature
implements Pings {
    private final ServiceReference<PingRequest, PingResponse> pinger;

    public PingsImpl(Session session, InternalSession internalSession) {
        super(session, internalSession);
        this.pinger = internalSession.getServiceLocator().obtainService(CommonServices.USER_PING);
    }

    @Override
    public CompletableFuture<Pings.PingDetails> pingServer() {
        Stopwatch stopwatch = new Stopwatch();
        return this.pinger.sendCommand(PingRequest.PING_REQUEST).thenApply(response -> new PingDetailsImpl(stopwatch.startTimeMillis(), stopwatch.elapsed()));
    }

    @Immutable
    static final class PingDetailsImpl
    implements Pings.PingDetails {
        private final long timestamp;
        private final long rtt;

        PingDetailsImpl(long requestSent, long elapsedMillis) {
            this.timestamp = requestSent;
            this.rtt = elapsedMillis;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public long getRoundTripTime() {
            return this.rtt;
        }

        public String toString() {
            return String.format("Ping sent to server at %tc, round trip time %s ms", this.timestamp, this.rtt);
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + (int)(this.timestamp ^ this.timestamp >>> 32);
            hash = hash * 31 + (int)(this.rtt ^ this.rtt >>> 32);
            return hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(PingDetailsImpl.class)) {
                return false;
            }
            PingDetailsImpl other = (PingDetailsImpl)o;
            return this.timestamp == other.timestamp && this.rtt == other.rtt;
        }
    }
}

