/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.topics;

import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.callbacks.Stream;
import com.pushtechnology.diffusion.client.session.Feature;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TopicNotifications
extends Feature {
    public CompletableFuture<NotificationRegistration> addListener(TopicNotificationListener var1);

    public static interface TopicNotificationListener
    extends Stream {
        public void onDescendantNotification(String var1, NotificationType var2);

        public void onTopicNotification(String var1, TopicSpecification var2, NotificationType var3);

        public static class Default
        extends Stream.Default
        implements TopicNotificationListener {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onTopicNotification(String topicPath, TopicSpecification specification, NotificationType type) {
                LOG.debug("Topic notification: path={}, specification={}, type={}", new Object[]{topicPath, specification, type});
            }

            @Override
            public void onDescendantNotification(String topicPath, NotificationType type) {
                LOG.debug("Descendant notification: path={}, type={}", (Object)topicPath, (Object)type);
            }
        }

        public static enum NotificationType {
            ADDED,
            SELECTED,
            REMOVED,
            DESELECTED;

        }
    }

    public static interface NotificationRegistration
    extends Registration {
        public CompletableFuture<?> select(TopicSelector var1);

        public CompletableFuture<?> select(String var1);

        public CompletableFuture<?> deselect(TopicSelector var1);

        public CompletableFuture<?> deselect(String var1);
    }
}

