/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.services.MissingTopicHandlerRegistration;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.command.commands.control.topics.RemoveTopicsRequest;
import com.pushtechnology.diffusion.command.commands.control.topics.TopicAddRequest;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.topics.details.TopicSpecificationImpl;
import com.pushtechnology.diffusion.topics.selectors.TopicSelectorParser;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class TopicControlImpl
extends AbstractFeature
implements TopicControl {
    private final ServiceReference<TopicAddRequest, TopicControl.AddTopicResult> topicAddService;
    private final ServiceReference<RemoveTopicsRequest, Integer> theTopicRemovalService;
    private final TopicSelectorParser theTopicSelectorParser;
    private final MissingTopicHandlerRegistration missingTopicHandlerRegistration;

    public TopicControlImpl(Session session, InternalSession internalSession, TopicSelectorParser topicSelectorParser, MissingTopicHandlerRegistration missingTopicHandlerRegistration) {
        super(session, internalSession);
        this.theTopicSelectorParser = topicSelectorParser;
        this.missingTopicHandlerRegistration = missingTopicHandlerRegistration;
        ServiceLocator serviceLocator = internalSession.getServiceLocator();
        this.theTopicRemovalService = serviceLocator.obtainService(CommonServices.TOPIC_REMOVAL);
        this.topicAddService = serviceLocator.obtainService(CommonServices.TOPIC_ADD);
    }

    @Override
    public CompletableFuture<TopicControl.AddTopicResult> addTopic(String topicPath, TopicType topicType) {
        String path = Objects.requireNonNull(topicPath, "topicPath is null");
        TopicType type = Objects.requireNonNull(topicType, "topicType is null");
        return this.topicAddService.sendCommand(new TopicAddRequest(path, new TopicSpecificationImpl(type))).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<TopicControl.AddTopicResult> addTopic(String topicPath, TopicSpecification specification) {
        String path = Objects.requireNonNull(topicPath, "topicPath is null");
        return this.topicAddService.sendCommand(new TopicAddRequest(path, Objects.requireNonNull(specification, "specification is null"))).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<TopicControl.TopicRemovalResult> removeTopics(TopicSelector topicSelector) {
        return this.theTopicRemovalService.sendCommand(new RemoveTopicsRequest(Objects.requireNonNull(topicSelector, "topicSelector is null").getExpression())).thenApply(r -> () -> r);
    }

    @Override
    public CompletableFuture<TopicControl.TopicRemovalResult> removeTopics(String topicSelector) throws IllegalArgumentException {
        return this.removeTopics(this.theTopicSelectorParser.parse(Objects.requireNonNull(topicSelector, "topicSelector is null")));
    }

    @Override
    public CompletableFuture<Registration> addMissingTopicHandler(String topicPath, TopicControl.MissingTopicNotificationStream handler) {
        return this.missingTopicHandlerRegistration.register(Objects.requireNonNull(topicPath, "topicPath is null"), Objects.requireNonNull(handler, "handler is null")).thenApply(Functions.identity());
    }
}

