/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.control.clients.SystemAuthenticationControl;
import com.pushtechnology.diffusion.client.features.control.impl.SecurityStoreFeatureImpl;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.java7.Functions;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class SystemAuthenticationControlImpl
extends SecurityStoreFeatureImpl
implements SystemAuthenticationControl {
    private final ServiceReference<Void, SystemAuthenticationControl.SystemAuthenticationConfiguration> getSystemAuthentication;

    public SystemAuthenticationControlImpl(Session session, InternalSession internalSession) {
        super(session, internalSession, CommonServices.UPDATE_SYSTEM_AUTHENTICATION);
        this.getSystemAuthentication = internalSession.getServiceLocator().obtainService(CommonServices.GET_SYSTEM_AUTHENTICATION);
    }

    @Override
    public CompletableFuture<SystemAuthenticationControl.SystemAuthenticationConfiguration> getSystemAuthentication() {
        return this.getSystemAuthentication.sendCommand(null).thenApply(Functions.identity());
    }

    @Override
    public SystemAuthenticationControl.ScriptBuilder scriptBuilder() {
        return new ScriptBuilderImpl();
    }

    @Immutable
    private static final class ScriptBuilderImpl
    implements SystemAuthenticationControl.ScriptBuilder {
        private final StringBuilder commands = new StringBuilder("");

        private ScriptBuilderImpl() {
        }

        private void maybeAppendNewLine() {
            if (this.commands.length() > 0) {
                this.commands.append('\n');
            }
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder addPrincipal(String name, String password, Set<String> roles) {
            String nonNullName = Objects.requireNonNull(name, "name is null");
            String nonNullPassword = Objects.requireNonNull(password, "password is null");
            Set<String> nonNullRoles = Objects.requireNonNull(roles, "roles is null");
            this.maybeAppendNewLine();
            this.commands.append("add principal ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullName)).append(' ').append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPassword));
            if (!nonNullRoles.isEmpty()) {
                this.commands.append(' ');
                SecurityStoreFeatureImpl.appendSet(this.commands, nonNullRoles);
            }
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder addPrincipal(String name, String password, Set<String> roles, String lockingPrincipal) {
            String requireNonNull = Objects.requireNonNull(lockingPrincipal, "lockingPrincipal is null");
            this.addPrincipal(name, password, roles);
            this.commands.append(" locked by ").append(SecurityStoreFeatureImpl.quoteAndEscape(requireNonNull));
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder setPassword(String principal, String password) {
            String nonNullPrincipal = Objects.requireNonNull(principal, "principal is null");
            String nonNullPassword = Objects.requireNonNull(password, "password is null");
            this.maybeAppendNewLine();
            this.commands.append("set password ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPrincipal)).append(' ').append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPassword));
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder verifyPassword(String principal, String password) {
            String nonNullPrincipal = Objects.requireNonNull(principal, "principal is null");
            String nonNullPassword = Objects.requireNonNull(password, "password is null");
            this.maybeAppendNewLine();
            this.commands.append("verify password ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPrincipal)).append(' ').append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPassword));
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder assignRoles(String principal, Set<String> roles) {
            String nonNullPrincipal = Objects.requireNonNull(principal, "principal is null");
            Set<String> nonNullRoles = Objects.requireNonNull(roles, "roles is null");
            this.maybeAppendNewLine();
            this.commands.append("assign roles ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPrincipal)).append(' ');
            SecurityStoreFeatureImpl.appendSet(this.commands, nonNullRoles);
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder removePrincipal(String principal) {
            String nonNullPrincipal = Objects.requireNonNull(principal, "principal is null");
            this.maybeAppendNewLine();
            this.commands.append("remove principal ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPrincipal));
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder allowAnonymousConnections(Set<String> roles) {
            Set<String> nonNullRoles = Objects.requireNonNull(roles, "roles is null");
            this.maybeAppendNewLine();
            this.commands.append("allow anonymous connections ");
            SecurityStoreFeatureImpl.appendSet(this.commands, nonNullRoles);
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder denyAnonymousConnections() {
            this.maybeAppendNewLine();
            this.commands.append("deny anonymous connections");
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder abstainAnonymousConnections() {
            this.maybeAppendNewLine();
            this.commands.append("abstain anonymous connections");
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder trustClientProposedPropertyIn(String propertyName, Set<String> allowedValues) {
            String nonNullPropertyName = Objects.requireNonNull(propertyName, "propertyName is null");
            Set<String> nonNullAllowedValues = Objects.requireNonNull(allowedValues, "allowedValues is null");
            if (nonNullAllowedValues.isEmpty()) {
                throw new IllegalArgumentException("No allowed values provided");
            }
            this.maybeAppendNewLine();
            this.commands.append("trust client proposed property ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPropertyName)).append(" if value in ");
            SecurityStoreFeatureImpl.appendSet(this.commands, nonNullAllowedValues);
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder trustClientProposedPropertyMatches(String propertyName, String regex) {
            String nonNullPropertyName = Objects.requireNonNull(propertyName, "propertyName is null");
            String nonNullRegex = Objects.requireNonNull(regex, "regex is null");
            this.maybeAppendNewLine();
            this.commands.append("trust client proposed property ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPropertyName)).append(" if value matches ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullRegex));
            return this;
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder ignoreClientProposedProperty(String propertyName) {
            String nonNullPropertyName = Objects.requireNonNull(propertyName, "propertyName is null");
            this.maybeAppendNewLine();
            this.commands.append("ignore client proposed property ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPropertyName));
            return this;
        }

        @Override
        public String script() {
            return this.commands.toString();
        }

        @Override
        public SystemAuthenticationControl.ScriptBuilder append(SystemAuthenticationControl.ScriptBuilder other) {
            this.maybeAppendNewLine();
            this.commands.append(other.script());
            return this;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + String.valueOf(this.commands) + "]";
        }
    }
}

