/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.control.impl.InternalClientControl;
import com.pushtechnology.diffusion.client.features.control.impl.SessionFetchContext;
import com.pushtechnology.diffusion.client.features.control.impl.SessionFetchResultImpl;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.command.commands.sessionfetch.SessionFetchQuery;
import com.pushtechnology.diffusion.command.commands.sessionfetch.SessionFetchQueryResult;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
final class SessionFetchRequestImpl
implements InternalClientControl.SessionFetchRequest {
    private final SessionFetchContext theContext;
    private final String theFilter;
    private final Set<String> theProperties;
    private final Instant theFromInstant;
    private final Instant theToInstant;
    private final int theLimit;
    private final int theMaximumResultSize;

    SessionFetchRequestImpl(SessionFetchContext context) {
        this(context, "all", null, SessionFetchQuery.DEFAULT_FROM, SessionFetchQuery.DEFAULT_TO, Integer.MAX_VALUE, context.getMaximumMessageSize());
    }

    private SessionFetchRequestImpl(SessionFetchContext context, String filter, Set<String> properties, Instant from, Instant to, int limit, int maximumResultSize) {
        this.theContext = context;
        this.theFilter = filter;
        this.theProperties = properties;
        this.theFromInstant = from;
        this.theToInstant = to;
        this.theLimit = limit;
        this.theMaximumResultSize = maximumResultSize;
    }

    @Override
    public InternalClientControl.SessionFetchRequest filter(String filter) {
        return new SessionFetchRequestImpl(this.theContext, Objects.requireNonNull(filter, "filter is null"), this.theProperties, this.theFromInstant, this.theToInstant, this.theLimit, this.theMaximumResultSize);
    }

    @Override
    public InternalClientControl.SessionFetchRequest withProperties(String ... requiredProperties) {
        return new SessionFetchRequestImpl(this.theContext, this.theFilter, (Set<String>)(requiredProperties.length > 0 && requiredProperties[0] == null ? null : ImmutableSet.of(requiredProperties)), this.theFromInstant, this.theToInstant, this.theLimit, this.theMaximumResultSize);
    }

    @Override
    public InternalClientControl.SessionFetchRequest from(Instant time) {
        if (Objects.requireNonNull(time, "time is null").isAfter(this.theToInstant)) {
            throw new IllegalArgumentException("time is after the 'to' time");
        }
        return new SessionFetchRequestImpl(this.theContext, this.theFilter, this.theProperties, time, this.theToInstant, this.theLimit, this.theMaximumResultSize);
    }

    @Override
    public InternalClientControl.SessionFetchRequest to(Instant time) {
        if (Objects.requireNonNull(time, "time is null").isBefore(this.theFromInstant)) {
            throw new IllegalArgumentException("time is before the 'from' time");
        }
        return new SessionFetchRequestImpl(this.theContext, this.theFilter, this.theProperties, this.theFromInstant, time, this.theLimit, this.theMaximumResultSize);
    }

    @Override
    public InternalClientControl.SessionFetchRequest first(int number) {
        return new SessionFetchRequestImpl(this.theContext, this.theFilter, this.theProperties, this.theFromInstant, this.theToInstant, SessionFetchRequestImpl.requireNonNegative(number, "number"), this.theMaximumResultSize);
    }

    @Override
    public InternalClientControl.SessionFetchRequest last(int number) {
        return new SessionFetchRequestImpl(this.theContext, this.theFilter, this.theProperties, this.theFromInstant, this.theToInstant, 0 - SessionFetchRequestImpl.requireNonNegative(number, "number"), this.theMaximumResultSize);
    }

    @Override
    public InternalClientControl.SessionFetchRequest maximumResultSize(int maximumSize) {
        if (maximumSize < 1024) {
            throw new IllegalArgumentException("maximumSize is invalid");
        }
        return new SessionFetchRequestImpl(this.theContext, this.theFilter, this.theProperties, this.theFromInstant, this.theToInstant, this.theLimit, Math.min(this.theContext.getMaximumMessageSize(), maximumSize));
    }

    @Override
    public CompletableFuture<InternalClientControl.SessionFetchResult> fetch() {
        boolean requiresStartTime = this.theProperties == null || this.theProperties.contains("$StartTime") || this.theProperties.contains("*F");
        SessionFetchQuery query = new SessionFetchQuery(this.theFilter, this.theProperties, this.theFromInstant, this.theToInstant, this.theLimit, this.theMaximumResultSize, requiresStartTime);
        return this.theContext.service().sendCommand(query).thenApply(r -> new SessionFetchResultImpl((SessionFetchQueryResult)r, requiresStartTime));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.theFilter.hashCode();
        result = 31 * result + this.theFromInstant.hashCode();
        result = 31 * result + this.theLimit;
        result = 31 * result + this.theMaximumResultSize;
        result = 31 * result + (this.theProperties == null ? 0 : this.theProperties.hashCode());
        result = 31 * result + this.theToInstant.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionFetchRequestImpl other = (SessionFetchRequestImpl)obj;
        return this.theFilter.equals(other.theFilter) && Objects.equals(this.theProperties, other.theProperties) && this.theFromInstant.equals(other.theFromInstant) && this.theToInstant.equals(other.theToInstant) && this.theLimit == other.theLimit && this.theMaximumResultSize == other.theMaximumResultSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("SessionFetchRequest [");
        if (this.theLimit == 0) {
            sb.append("No results");
        } else if (this.theLimit == Integer.MAX_VALUE) {
            sb.append("All results");
        } else if (this.theLimit > 0) {
            sb.append("First ").append(this.theLimit);
        } else {
            sb.append("Last ").append(-this.theLimit);
        }
        sb.append(", Filter=").append(this.theFilter);
        sb.append(", Requested properties=");
        if (this.theProperties == null) {
            sb.append("All");
        } else if (this.theProperties.isEmpty()) {
            sb.append("None");
        } else {
            sb.append(this.theProperties);
        }
        if (!this.theFromInstant.equals(SessionFetchQuery.DEFAULT_FROM)) {
            sb.append(", From=").append(this.theFromInstant);
        }
        if (!this.theToInstant.equals(SessionFetchQuery.DEFAULT_TO)) {
            sb.append(", To=").append(this.theToInstant);
        }
        sb.append(", Maximum result size=").append(this.theMaximumResultSize).append(']');
        return sb.toString();
    }

    private static int requireNonNegative(int n, String parameter) {
        if (n < 0) {
            throw new IllegalArgumentException(parameter + " must be non-negative");
        }
        return n;
    }
}

