/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.ScriptException;
import com.pushtechnology.diffusion.client.features.control.clients.SecurityStoreFeature;
import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.types.ErrorReport;
import com.pushtechnology.diffusion.client.types.Permission;
import com.pushtechnology.diffusion.command.commands.control.client.SecurityCommandScript;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.ServiceDefinition;
import com.pushtechnology.diffusion.types.ErrorReportList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

abstract class SecurityStoreFeatureImpl
extends AbstractFeature
implements SecurityStoreFeature {
    private static final char SPACE = ' ';
    private static final char BACKSLASH = '\\';
    private static final char SINGLE_QUOTE = '\'';
    private final ServiceReference<SecurityCommandScript, ErrorReportList> updateStore;

    protected static String quoteAndEscape(String s) {
        StringBuilder sb = new StringBuilder((int)((double)s.length() * 1.1));
        sb.append('\'');
        if (s.indexOf(39) < 0 && s.indexOf(92) < 0) {
            sb.append(s);
        } else {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\'' || c == '\\') {
                    sb.append('\\');
                }
                sb.append(c);
            }
        }
        sb.append('\'');
        return sb.toString();
    }

    protected static void appendSet(StringBuilder sb, Set<String> stringSet) {
        sb.append('[');
        boolean first = true;
        for (String s : stringSet) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(SecurityStoreFeatureImpl.quoteAndEscape(s));
        }
        sb.append(']');
    }

    protected static void appendPermissions(StringBuilder sb, Set<? extends Permission> permissions) {
        sb.append('[');
        boolean first = true;
        for (Permission permission : permissions) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(permission.toString());
        }
        sb.append(']');
    }

    SecurityStoreFeatureImpl(Session session, InternalSession internalSession, ServiceDefinition<SecurityCommandScript, ErrorReportList> updateStoreService) {
        super(session, internalSession);
        this.updateStore = internalSession.getServiceLocator().obtainService(updateStoreService);
    }

    @Override
    public CompletableFuture<?> updateStore(String commandScript) {
        return this.updateStore.sendCommand(new SecurityCommandScript(Objects.requireNonNull(commandScript, "commandScript is null"))).thenApply(result -> {
            List<ErrorReport> errors = result.getErrors();
            if (!errors.isEmpty()) {
                throw new ScriptException("updateStore failed", errors);
            }
            return null;
        });
    }
}

