/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.control.clients.SecurityControl;
import com.pushtechnology.diffusion.client.features.control.impl.SecurityStoreFeatureImpl;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.types.GlobalPermission;
import com.pushtechnology.diffusion.client.types.PathPermission;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.java7.Functions;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;

@Immutable
public final class SecurityControlImpl
extends SecurityStoreFeatureImpl
implements SecurityControl {
    private final ServiceReference<Void, SecurityControl.SecurityConfiguration> getSecurity;

    public SecurityControlImpl(Session session, InternalSession internalSession) {
        super(session, internalSession, CommonServices.UPDATE_SECURITY);
        this.getSecurity = internalSession.getServiceLocator().obtainService(CommonServices.GET_SECURITY);
    }

    @Override
    public CompletableFuture<SecurityControl.SecurityConfiguration> getSecurity() {
        return this.getSecurity.sendCommand(null).thenApply(Functions.identity());
    }

    @Override
    public SecurityControl.ScriptBuilder scriptBuilder() {
        return new ScriptBuilderImpl();
    }

    @NotThreadSafe
    private static final class ScriptBuilderImpl
    implements SecurityControl.ScriptBuilder {
        private final StringBuilder commands = new StringBuilder("");

        private ScriptBuilderImpl() {
        }

        private void maybeAppendNewLine() {
            if (this.commands.length() > 0) {
                this.commands.append('\n');
            }
        }

        @Override
        public SecurityControl.ScriptBuilder setRolesForAnonymousSessions(Set<String> roles) {
            Set<String> nonNullRoles = Objects.requireNonNull(roles, "roles is null");
            this.maybeAppendNewLine();
            this.commands.append("set roles for anonymous sessions ");
            SecurityStoreFeatureImpl.appendSet(this.commands, nonNullRoles);
            return this;
        }

        @Override
        public SecurityControl.ScriptBuilder setRolesForNamedSessions(Set<String> roles) {
            Set<String> nonNullRoles = Objects.requireNonNull(roles, "roles is null");
            this.maybeAppendNewLine();
            this.commands.append("set roles for named sessions ");
            SecurityStoreFeatureImpl.appendSet(this.commands, nonNullRoles);
            return this;
        }

        @Override
        public SecurityControl.ScriptBuilder setGlobalPermissions(String role, Set<GlobalPermission> permissions) {
            String nonNullRole = Objects.requireNonNull(role, "role is null");
            Set<GlobalPermission> nonNullPermissions = Objects.requireNonNull(permissions, "permissions is null");
            this.maybeAppendNewLine();
            this.commands.append("set ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullRole)).append(" permissions ");
            SecurityStoreFeatureImpl.appendPermissions(this.commands, nonNullPermissions);
            return this;
        }

        @Override
        public SecurityControl.ScriptBuilder setDefaultPathPermissions(String role, Set<PathPermission> permissions) {
            String nonNullRole = Objects.requireNonNull(role, "role is null");
            Set<PathPermission> nonNullPermissions = Objects.requireNonNull(permissions, "permissions is null");
            this.maybeAppendNewLine();
            this.commands.append("set ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullRole)).append(" default path permissions ");
            SecurityStoreFeatureImpl.appendPermissions(this.commands, nonNullPermissions);
            return this;
        }

        @Override
        public SecurityControl.ScriptBuilder isolatePath(String path) {
            String nonNullPath = Objects.requireNonNull(path, "path is null");
            this.maybeAppendNewLine();
            this.commands.append("isolate path ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPath));
            return this;
        }

        @Override
        public SecurityControl.ScriptBuilder deisolatePath(String path) {
            String nonNullPath = Objects.requireNonNull(path, "path is null");
            this.maybeAppendNewLine();
            this.commands.append("deisolate path ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPath));
            return this;
        }

        @Override
        public SecurityControl.ScriptBuilder setPathPermissions(String role, String path, Set<PathPermission> permissions) {
            String nonNullRole = Objects.requireNonNull(role, "role is null");
            String nonNullPath = Objects.requireNonNull(path, "path is null");
            Set<PathPermission> nonNullPermissions = Objects.requireNonNull(permissions, "permissions is null");
            this.maybeAppendNewLine();
            this.commands.append("set ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullRole)).append(" path ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPath)).append(" permissions ");
            SecurityStoreFeatureImpl.appendPermissions(this.commands, nonNullPermissions);
            return this;
        }

        @Override
        public SecurityControl.ScriptBuilder removePathPermissions(String role, String path) {
            String nonNullRole = Objects.requireNonNull(role, "role is null");
            String nonNullPath = Objects.requireNonNull(path, "path is null");
            this.maybeAppendNewLine();
            this.commands.append("remove ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullRole)).append(" permissions for path ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPath));
            return this;
        }

        @Override
        public SecurityControl.ScriptBuilder setRoleIncludes(String role, Set<String> includedRoles) {
            String nonNullRole = Objects.requireNonNull(role, "role is null");
            Set<String> nonNullIncludedRoles = Objects.requireNonNull(includedRoles, "includedRoles is null");
            this.maybeAppendNewLine();
            this.commands.append("set ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullRole)).append(" includes ");
            SecurityStoreFeatureImpl.appendSet(this.commands, nonNullIncludedRoles);
            return this;
        }

        @Override
        public SecurityControl.ScriptBuilder setRoleLockedByPrincipal(String role, String lockingPrincipal) {
            String nonNullRole = Objects.requireNonNull(role, "role is null");
            String nonNullPrincipal = Objects.requireNonNull(lockingPrincipal, "lockingPrincipal is null");
            this.maybeAppendNewLine();
            this.commands.append("set role ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullRole)).append(" locked by principal ").append(SecurityStoreFeatureImpl.quoteAndEscape(nonNullPrincipal));
            return this;
        }

        @Override
        public String script() {
            return this.commands.toString();
        }

        @Override
        public SecurityControl.ScriptBuilder append(SecurityControl.ScriptBuilder other) {
            this.maybeAppendNewLine();
            this.commands.append(other.script());
            return this;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + String.valueOf(this.commands) + "]";
        }
    }
}

