/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.features.control.impl.RemoteServerBuilderImpl;
import com.pushtechnology.diffusion.client.topics.TopicSelectors;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.client.types.impl.CredentialsImpl;
import com.pushtechnology.diffusion.configuration.LimitTimeouts;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
abstract class SecondaryBuilderImpl<B>
extends RemoteServerBuilderImpl<B>
implements RemoteServers.SecondaryServer.SecondaryBuilder<B> {
    private static final EnumSet<RemoteServers.RemoteServer.ConnectionOption> INVALID_ACCEPTOR_OPTIONS = EnumSet.of(RemoteServers.RemoteServer.ConnectionOption.RECONNECTION_TIMEOUT, RemoteServers.RemoteServer.ConnectionOption.RETRY_DELAY, RemoteServers.RemoteServer.ConnectionOption.RECOVERY_BUFFER_SIZE);
    private String thePrincipal = "";
    private Credentials theCredentials = CredentialsImpl.NO_CREDENTIALS;
    private final TopicSelectors theTopicSelectors;
    private Map<RemoteServers.RemoteServer.ConnectionOption, String> theConnectionOptions = new HashMap<RemoteServers.RemoteServer.ConnectionOption, String>();
    private String theMissingTopicNotificationFilter = null;

    SecondaryBuilderImpl(RemoteServers.RemoteServer.Type type, TopicSelectors topicSelectors) {
        super(type);
        this.theTopicSelectors = topicSelectors;
    }

    @Override
    public final B principal(String principal) {
        this.thePrincipal = principal == null ? "" : principal;
        return (B)this;
    }

    @Override
    public final B credentials(Credentials credentials) {
        this.theCredentials = credentials == null ? CredentialsImpl.NO_CREDENTIALS : credentials;
        return (B)this;
    }

    @Override
    public final B connectionOptions(Map<RemoteServers.RemoteServer.ConnectionOption, String> connectionOptions) {
        if (connectionOptions == null) {
            this.theConnectionOptions = new HashMap<RemoteServers.RemoteServer.ConnectionOption, String>();
        } else {
            HashMap<RemoteServers.RemoteServer.ConnectionOption, String> newOptions = new HashMap<RemoteServers.RemoteServer.ConnectionOption, String>(connectionOptions.size());
            for (Map.Entry<RemoteServers.RemoteServer.ConnectionOption, String> entry : connectionOptions.entrySet()) {
                RemoteServers.RemoteServer.ConnectionOption option = entry.getKey();
                newOptions.put(option, this.validateConnectionOption(option, entry.getValue()));
            }
            this.theConnectionOptions = newOptions;
        }
        return (B)this;
    }

    @Override
    public final B connectionOption(RemoteServers.RemoteServer.ConnectionOption connectionOption, String value) {
        RemoteServers.RemoteServer.ConnectionOption option = Objects.requireNonNull(connectionOption, "connectionOption is null");
        if (value == null) {
            this.theConnectionOptions.remove((Object)option);
        } else {
            this.theConnectionOptions.put(option, this.validateConnectionOption(option, value));
        }
        return (B)this;
    }

    @Override
    public final B missingTopicNotificationFilter(String filter) {
        if (filter != null) {
            try {
                this.theTopicSelectors.parse(filter);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("filter is invalid : " + ex.getMessage());
            }
        }
        this.theMissingTopicNotificationFilter = filter;
        return (B)this;
    }

    protected final String getPrincipal() {
        return this.thePrincipal;
    }

    protected final Credentials getCredentials() {
        return this.theCredentials;
    }

    final Map<RemoteServers.RemoteServer.ConnectionOption, String> getConnectionOptions() {
        return this.theConnectionOptions;
    }

    final String getMissingTopicNotificationFilter() {
        return this.theMissingTopicNotificationFilter;
    }

    @Override
    public B reset() {
        this.thePrincipal = "";
        this.theCredentials = CredentialsImpl.NO_CREDENTIALS;
        this.theConnectionOptions = new HashMap<RemoteServers.RemoteServer.ConnectionOption, String>();
        this.theMissingTopicNotificationFilter = null;
        return (B)this;
    }

    private String validateConnectionOption(RemoteServers.RemoteServer.ConnectionOption option, String value) {
        this.validateOption(option, value);
        switch (option) {
            case CONNECTION_TIMEOUT: 
            case WRITE_TIMEOUT: 
            case RECONNECTION_TIMEOUT: {
                return SecondaryBuilderImpl.timeoutOption(option, value);
            }
            case INPUT_BUFFER_SIZE: 
            case OUTPUT_BUFFER_SIZE: {
                return SecondaryBuilderImpl.minimumValueOption(option, value, 1024);
            }
            case MAXIMUM_QUEUE_SIZE: {
                return SecondaryBuilderImpl.minimumValueOption(option, value, 1);
            }
            case RECOVERY_BUFFER_SIZE: {
                return SecondaryBuilderImpl.minimumValueOption(option, value, 0);
            }
            case RETRY_DELAY: {
                return SecondaryBuilderImpl.minimumValueOption(option, value, 0);
            }
        }
        throw new IllegalArgumentException("Unknown option " + String.valueOf((Object)option));
    }

    private void validateOption(RemoteServers.RemoteServer.ConnectionOption option, String value) {
        if (value == null) {
            throw new NullPointerException("Connection Option '" + String.valueOf((Object)option) + "' value is null");
        }
        if (this.getType() == RemoteServers.RemoteServer.Type.SECONDARY_ACCEPTOR && INVALID_ACCEPTOR_OPTIONS.contains((Object)option)) {
            throw new IllegalArgumentException("Connection Option " + String.valueOf((Object)option) + " cannot be specified for " + String.valueOf((Object)RemoteServers.RemoteServer.Type.SECONDARY_ACCEPTOR) + " servers");
        }
    }

    private static String minimumValueOption(RemoteServers.RemoteServer.ConnectionOption option, String value, int minimum) {
        try {
            int size = Integer.parseInt(value.trim());
            if (size < minimum) {
                throw new IllegalArgumentException("Connection Option '" + String.valueOf((Object)option) + "' value '" + value + "' cannot be less than " + minimum);
            }
            return Integer.toString(size);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Connection Option '" + String.valueOf((Object)option) + "' value '" + value + "' is invalid", ex);
        }
    }

    private static String timeoutOption(RemoteServers.RemoteServer.ConnectionOption option, String value) {
        try {
            return Integer.toString(LimitTimeouts.limitTimeout(option.toString(), Long.parseLong(value.trim())));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Connection Option '" + String.valueOf((Object)option) + "' value '" + value + "' is invalid", ex);
        }
    }
}

