/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.features.control.impl.InternalRemoteServers;
import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.servers.CreateRemoteServerResult;
import com.pushtechnology.diffusion.servers.ListRemoteServersResult;
import com.pushtechnology.diffusion.servers.RemoteServerDefinition;
import com.pushtechnology.diffusion.servers.SecondaryAcceptorRegistration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class RemoteServersImpl
extends AbstractFeature
implements InternalRemoteServers {
    private final ServiceReference<RemoteServerDefinition, CreateRemoteServerResult> createRemoteServerService;
    private final ServiceReference<String, Void> removeRemoteServerService;
    private final ServiceReference<Void, ListRemoteServersResult> listRemoteServersService;
    private final ServiceReference<String, RemoteServers.CheckRemoteServerResult> checkRemoteServerService;
    private final ServiceReference<SecondaryAcceptorRegistration, Void> registerSecondaryAcceptorService;

    public RemoteServersImpl(Session session, InternalSession internalSession) {
        super(session, internalSession);
        ServiceLocator services = internalSession.getServiceLocator();
        this.createRemoteServerService = services.obtainService(CommonServices.CREATE_REMOTE_SERVER);
        this.removeRemoteServerService = services.obtainService(CommonServices.REMOVE_REMOTE_SERVER);
        this.listRemoteServersService = services.obtainService(CommonServices.LIST_REMOTE_SERVERS);
        this.checkRemoteServerService = services.obtainService(CommonServices.CHECK_REMOTE_SERVER);
        this.registerSecondaryAcceptorService = services.obtainService(CommonServices.SECONDARY_ACCEPTOR_REGISTRATION);
    }

    @Override
    public CompletableFuture<RemoteServers.RemoteServer> createRemoteServer(RemoteServers.RemoteServer remoteServer) {
        if (!(Objects.requireNonNull(remoteServer, "remoteServer is null") instanceof RemoteServerDefinition)) {
            throw new IllegalArgumentException("remoteServer instance was not created using remote server builder");
        }
        return this.createRemoteServerFromDefinition((RemoteServerDefinition)remoteServer);
    }

    private CompletableFuture<RemoteServers.RemoteServer> createRemoteServerFromDefinition(RemoteServerDefinition remoteServer) {
        return this.createRemoteServerService.sendCommand(remoteServer).thenCompose(result -> {
            if (result.isSuccess()) {
                return CompletableFuture.completedFuture(result.getRemoteServer());
            }
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new RemoteServers.RemoteServerOptionsException("Failed to create remote server '" + remoteServer.getName() + "'", result.getErrors()));
            return future;
        });
    }

    @Override
    public CompletableFuture<List<RemoteServers.RemoteServer>> listRemoteServers() {
        return this.listRemoteServersService.sendCommand(null).thenApply(ListRemoteServersResult::getServers);
    }

    @Override
    public CompletableFuture<Void> removeRemoteServer(String name) {
        return this.removeRemoteServerService.sendCommand(Objects.requireNonNull(name, "name is null")).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<RemoteServers.CheckRemoteServerResult> checkRemoteServer(String name) {
        return this.checkRemoteServerService.sendCommand(Objects.requireNonNull(name, "name is null")).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<Void> registerSecondaryAcceptor(String serverName, String requestId) {
        return this.registerSecondaryAcceptorService.sendCommand(new SecondaryAcceptorRegistration(Objects.requireNonNull(serverName, "serverName is null"), Objects.requireNonNull(requestId, "requestId is null"))).thenApply(Functions.identity());
    }
}

