/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.features.control.impl.RemoteServerBuilderImpl;
import com.pushtechnology.diffusion.servers.RemoteServerDefinitionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class PrimaryInitiatorBuilderImpl
extends RemoteServerBuilderImpl<RemoteServers.PrimaryInitiator.PrimaryInitiatorBuilder>
implements RemoteServers.PrimaryInitiator.PrimaryInitiatorBuilder {
    private int theRetryDelay = 1000;

    public PrimaryInitiatorBuilderImpl() {
        super(RemoteServers.RemoteServer.Type.PRIMARY_INITIATOR);
    }

    @Override
    public RemoteServers.PrimaryInitiator.PrimaryInitiatorBuilder retryDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("delay is invalid");
        }
        this.theRetryDelay = delay;
        return this;
    }

    @Override
    public RemoteServers.PrimaryInitiator.PrimaryInitiatorBuilder reset() {
        this.theRetryDelay = 1000;
        return this;
    }

    @Override
    public RemoteServers.PrimaryInitiator build(String name, List<String> urls, String connector) {
        return RemoteServerDefinitionImpl.createPrimaryDefinition(PrimaryInitiatorBuilderImpl.validateName(name), this.validateUrls(Objects.requireNonNull(urls, "urls is null")), this.theRetryDelay, PrimaryInitiatorBuilderImpl.validateConnector(connector));
    }

    private List<String> validateUrls(List<String> urls) {
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("urls is empty");
        }
        ArrayList<String> newUrls = new ArrayList<String>(urls.size());
        for (String url : urls) {
            newUrls.add(this.validateUrl(url));
        }
        return newUrls;
    }

    private static String validateConnector(String connector) {
        String trimmedName = Objects.requireNonNull(connector, "connector is null").trim();
        if (trimmedName.length() == 0) {
            throw new IllegalArgumentException("Non whitespace connector must be supplied");
        }
        return trimmedName;
    }
}

