/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.statistics.MetricsResultImpl;
import com.pushtechnology.diffusion.statistics.SerializableMetricsRequest;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;

@Immutable
public final class MetricsRequestImpl
implements Metrics.MetricsRequest {
    private final Set<String> filters;
    private final Pattern patternFilter;
    private final String server;
    private final SerializableMetricsRequest.RequestType requestType;
    private final ServiceReference<SerializableMetricsRequest, MetricsResultImpl> getMetrics;

    private MetricsRequestImpl(Set<String> filters, Pattern patternFilter, String server, SerializableMetricsRequest.RequestType requestType, ServiceReference<SerializableMetricsRequest, MetricsResultImpl> getMetrics) {
        this.filters = filters;
        this.patternFilter = patternFilter;
        this.server = server;
        this.requestType = requestType;
        this.getMetrics = getMetrics;
    }

    public static MetricsRequestImpl create(ServiceReference<SerializableMetricsRequest, MetricsResultImpl> getMetrics) {
        return new MetricsRequestImpl(Collections.emptySet(), null, null, SerializableMetricsRequest.RequestType.ALL_SERVERS, getMetrics);
    }

    @Override
    public Metrics.MetricsRequest filter(Set<String> newFilters) {
        Objects.requireNonNull(newFilters, "filters must not be null");
        return new MetricsRequestImpl(new HashSet<String>(newFilters), null, this.server, this.requestType, this.getMetrics);
    }

    @Override
    public Metrics.MetricsRequest filter(Pattern filter) {
        Objects.requireNonNull(filter, "pattern filter must not be null");
        return new MetricsRequestImpl(Collections.emptySet(), filter, this.server, this.requestType, this.getMetrics);
    }

    @Override
    public Metrics.MetricsRequest server(String newServer) {
        if (newServer == null || newServer.isEmpty()) {
            throw new IllegalArgumentException("server must not be null or empty");
        }
        return new MetricsRequestImpl(this.filters, this.patternFilter, newServer, SerializableMetricsRequest.RequestType.NAMED_SERVER, this.getMetrics);
    }

    @Override
    public Metrics.MetricsRequest currentServer() {
        return new MetricsRequestImpl(this.filters, this.patternFilter, null, SerializableMetricsRequest.RequestType.CURRENT_SERVER, this.getMetrics);
    }

    @Override
    public CompletableFuture<Metrics.MetricsResult> fetch() {
        SerializableMetricsRequest request = new SerializableMetricsRequest(this.filters, this.patternFilter, this.server, this.requestType);
        return this.getMetrics.sendCommand(request).thenApply(x -> x);
    }

    public String toString() {
        return "MetricsRequest[filters=" + String.valueOf(this.filters) + ", patternFilter=" + String.valueOf(this.patternFilter) + ", server='" + this.server + "', requestType=" + String.valueOf((Object)this.requestType) + "]";
    }
}

