/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.features.InvalidFilterException;
import com.pushtechnology.diffusion.client.features.ScriptException;
import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.client.features.control.impl.InternalMetrics;
import com.pushtechnology.diffusion.client.features.control.impl.MetricsRequestImpl;
import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.types.ErrorReport;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.metrics.alerts.ListMetricAlertsResult;
import com.pushtechnology.diffusion.metrics.alerts.SetMetricAlertRequest;
import com.pushtechnology.diffusion.metrics.alerts.SetMetricAlertResult;
import com.pushtechnology.diffusion.statistics.MeasuredEntityClassMetrics;
import com.pushtechnology.diffusion.statistics.MeasuredEntityClassMetricsRequest;
import com.pushtechnology.diffusion.statistics.MetricsResultImpl;
import com.pushtechnology.diffusion.statistics.SerializableMetricsRequest;
import com.pushtechnology.diffusion.statistics.ServerMetrics;
import com.pushtechnology.diffusion.statistics.metriccollectors.service.SessionMetricCollectorList;
import com.pushtechnology.diffusion.statistics.metriccollectors.service.TopicMetricCollectorList;
import com.pushtechnology.diffusion.types.ErrorReportList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public final class MetricsImpl
extends AbstractFeature
implements InternalMetrics {
    private final ServiceReference<Void, SessionMetricCollectorList> listSessionMetricCollectors;
    private final ServiceReference<Metrics.SessionMetricCollector, ErrorReportList> putSessionMetricCollector;
    private final ServiceReference<String, Void> removeSessionMetricCollector;
    private final ServiceReference<Void, TopicMetricCollectorList> listTopicMetricCollectors;
    private final ServiceReference<Metrics.TopicMetricCollector, Void> putTopicMetricCollector;
    private final ServiceReference<String, Void> removeTopicMetricCollector;
    private final ServiceReference<Void, ServerMetrics> getServerMetrics;
    private final ServiceReference<MeasuredEntityClassMetricsRequest, MeasuredEntityClassMetrics> getMeasuredEntityClassMetrics;
    private final ServiceReference<SerializableMetricsRequest, MetricsResultImpl> getMetrics;
    private final ServiceReference<SetMetricAlertRequest, SetMetricAlertResult> setMetricAlert;
    private final ServiceReference<Void, ListMetricAlertsResult> listMetricAlert;
    private final ServiceReference<String, Void> removeMetricAlert;

    public MetricsImpl(Session session, InternalSession internalSession) {
        super(session, internalSession);
        ServiceLocator services = internalSession.getServiceLocator();
        this.listSessionMetricCollectors = services.obtainService(CommonServices.LIST_SESSION_METRIC_COLLECTORS);
        this.putSessionMetricCollector = services.obtainService(CommonServices.PUT_SESSION_METRIC_COLLECTOR);
        this.removeSessionMetricCollector = services.obtainService(CommonServices.REMOVE_SESSION_METRIC_COLLECTOR);
        this.listTopicMetricCollectors = services.obtainService(CommonServices.LIST_TOPIC_METRIC_COLLECTORS);
        this.putTopicMetricCollector = services.obtainService(CommonServices.PUT_TOPIC_METRIC_COLLECTOR);
        this.removeTopicMetricCollector = services.obtainService(CommonServices.REMOVE_TOPIC_METRIC_COLLECTOR);
        this.getServerMetrics = services.obtainService(CommonServices.GET_SERVER_METRICS);
        this.getMeasuredEntityClassMetrics = services.obtainService(CommonServices.GET_MEASURED_ENTITY_CLASS_METRICS);
        this.getMetrics = services.obtainService(CommonServices.GET_METRICS);
        this.setMetricAlert = services.obtainService(CommonServices.SET_METRIC_ALERT);
        this.listMetricAlert = services.obtainService(CommonServices.LIST_METRIC_ALERTS);
        this.removeMetricAlert = services.obtainService(CommonServices.REMOVE_METRIC_ALERT);
    }

    @Override
    public CompletableFuture<List<Metrics.SessionMetricCollector>> listSessionMetricCollectors() {
        return this.listSessionMetricCollectors.sendCommand(null).thenApply(SessionMetricCollectorList::getCollectors);
    }

    @Override
    public CompletableFuture<?> putSessionMetricCollector(Metrics.SessionMetricCollector collector) {
        return this.putSessionMetricCollector.sendCommand(collector).thenCompose(result -> {
            if (result.getErrors().isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            List<ErrorReport> errors = result.getErrors();
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new InvalidFilterException("Session filter expression is invalid", errors));
            return future;
        });
    }

    @Override
    public CompletableFuture<?> removeSessionMetricCollector(String name) {
        return this.removeSessionMetricCollector.sendCommand(name).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<List<Metrics.TopicMetricCollector>> listTopicMetricCollectors() {
        return this.listTopicMetricCollectors.sendCommand(null).thenApply(TopicMetricCollectorList::getCollectors);
    }

    @Override
    public CompletableFuture<?> putTopicMetricCollector(Metrics.TopicMetricCollector collector) {
        return this.putTopicMetricCollector.sendCommand(collector).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<?> removeTopicMetricCollector(String name) {
        return this.removeTopicMetricCollector.sendCommand(name).thenApply(Functions.identity());
    }

    @Override
    public Metrics.MetricsRequest metricsRequest() {
        return MetricsRequestImpl.create(this.getMetrics);
    }

    @Override
    public CompletableFuture<ServerMetrics> getServerMetrics() {
        return this.getServerMetrics.sendCommand(null);
    }

    @Override
    public CompletableFuture<MeasuredEntityClassMetrics> getMeasuredEntityClassMetrics(String measuredEntityClassName) {
        MeasuredEntityClassMetricsRequest request = new MeasuredEntityClassMetricsRequest(measuredEntityClassName);
        return this.getMeasuredEntityClassMetrics.sendCommand(request);
    }

    @Override
    public CompletableFuture<MeasuredEntityClassMetrics> getMeasuredEntityClassMetrics(String measuredEntityClassName, String serverName) {
        MeasuredEntityClassMetricsRequest request = new MeasuredEntityClassMetricsRequest(measuredEntityClassName, serverName);
        return this.getMeasuredEntityClassMetrics.sendCommand(request);
    }

    @Override
    public CompletableFuture<?> setMetricAlert(String name, String specification) {
        if (Objects.requireNonNull(name, "name is null").isEmpty()) {
            throw new IllegalArgumentException("Name cannot be an empty string.");
        }
        Objects.requireNonNull(specification, "specification is null");
        return this.setMetricAlert.sendCommand(new SetMetricAlertRequest(name, specification)).thenCompose(result -> {
            if (result.getErrors().isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            List<ErrorReport> errors = result.getErrors();
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new ScriptException("Metric alert specification is invalid", errors));
            return future;
        });
    }

    @Override
    public CompletableFuture<List<Metrics.MetricAlert>> listMetricAlerts() {
        return this.listMetricAlert.sendCommand(null).thenApply(ListMetricAlertsResult::getAlerts);
    }

    @Override
    public CompletableFuture<?> removeMetricAlert(String name) {
        return this.removeMetricAlert.sendCommand(name).thenApply(Functions.identity());
    }
}

