/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.impl;

import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.features.control.clients.ClientControl;
import com.pushtechnology.diffusion.client.features.control.impl.InternalClientControl;
import com.pushtechnology.diffusion.client.features.control.impl.SessionFetchContext;
import com.pushtechnology.diffusion.client.features.control.impl.SessionFetchRequestImpl;
import com.pushtechnology.diffusion.client.features.impl.AbstractFeature;
import com.pushtechnology.diffusion.client.internal.services.QueueEventHandlerRegistration;
import com.pushtechnology.diffusion.client.internal.services.SessionEventRegistration;
import com.pushtechnology.diffusion.client.internal.session.InternalSession;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.command.commands.control.client.ChangeAuthorisationRolesFilterRequest;
import com.pushtechnology.diffusion.command.commands.control.client.ChangeAuthorisationRolesRequest;
import com.pushtechnology.diffusion.command.commands.control.client.CloseClientRequest;
import com.pushtechnology.diffusion.command.commands.control.client.CountOrParserErrors;
import com.pushtechnology.diffusion.command.commands.control.client.GetSessionPropertiesRequest;
import com.pushtechnology.diffusion.command.commands.control.client.GetSessionPropertiesResult;
import com.pushtechnology.diffusion.command.commands.control.client.SetClientQueueConflationFilterRequest;
import com.pushtechnology.diffusion.command.commands.control.client.SetClientQueueConflationRequest;
import com.pushtechnology.diffusion.command.commands.control.client.SetSessionPropertiesFilterRequest;
import com.pushtechnology.diffusion.command.commands.control.client.SetSessionPropertiesRequest;
import com.pushtechnology.diffusion.command.commands.control.client.SetSessionPropertiesResult;
import com.pushtechnology.diffusion.command.commands.sessionlocks.GetSessionLockResult;
import com.pushtechnology.diffusion.command.commands.sessionlocks.GetSessionLocksResult;
import com.pushtechnology.diffusion.command.sender.ServiceLocator;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.command.services.definition.CommonServices;
import com.pushtechnology.diffusion.java7.Functions;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;

@Immutable
public class ClientControlImpl
extends AbstractFeature
implements InternalClientControl {
    private final QueueEventHandlerRegistration queueEventHandlerRegistration;
    private final SessionEventRegistration sessionEventRegistration;
    private final ServiceReference<SetClientQueueConflationRequest, Void> conflateService;
    private final ServiceReference<SetClientQueueConflationFilterRequest, CountOrParserErrors> conflateFilterService;
    private final ServiceReference<CloseClientRequest, Void> closeService;
    private final ServiceReference<ChangeAuthorisationRolesFilterRequest, CountOrParserErrors> changeRolesFilterService;
    private final ServiceReference<ChangeAuthorisationRolesRequest, Void> changeRolesService;
    private final ServiceReference<SetSessionPropertiesRequest, SetSessionPropertiesResult> setSessionPropertiesService;
    private final ServiceReference<SetSessionPropertiesFilterRequest, CountOrParserErrors> setSessionFilterService;
    private final ServiceReference<GetSessionPropertiesRequest, GetSessionPropertiesResult> getSessionPropertiesService;
    private final ServiceReference<String, CountOrParserErrors> closeFilterService;
    private final ServiceReference<String, GetSessionLockResult> getSessionLockService;
    private final ServiceReference<Void, GetSessionLocksResult> getSessionLocksService;
    private final SessionFetchContext sessionFetchContext;

    public ClientControlImpl(Session session, InternalSession internalSession, QueueEventHandlerRegistration queueEventHandlerRegistration, SessionEventRegistration sessionEventRegistration) {
        super(session, internalSession);
        this.queueEventHandlerRegistration = queueEventHandlerRegistration;
        this.sessionEventRegistration = sessionEventRegistration;
        ServiceLocator serviceLocator = internalSession.getServiceLocator();
        this.closeService = serviceLocator.obtainService(CommonServices.CLOSE_CLIENT);
        this.conflateService = serviceLocator.obtainService(CommonServices.SET_CLIENT_CONFLATION);
        this.changeRolesFilterService = serviceLocator.obtainService(CommonServices.CHANGE_AUTHORISATION_ROLES_FILTER);
        this.changeRolesService = serviceLocator.obtainService(CommonServices.CHANGE_AUTHORISATION_ROLES);
        this.setSessionPropertiesService = serviceLocator.obtainService(CommonServices.SET_SESSION_PROPERTIES);
        this.setSessionFilterService = serviceLocator.obtainService(CommonServices.SET_SESSION_PROPERTIES_FILTER);
        this.getSessionPropertiesService = serviceLocator.obtainService(CommonServices.GET_SESSION_PROPERTIES);
        this.closeFilterService = serviceLocator.obtainService(CommonServices.CLOSE_CLIENT_FILTER);
        this.conflateFilterService = serviceLocator.obtainService(CommonServices.SET_CLIENT_CONFLATION_FILTER);
        this.getSessionLockService = serviceLocator.obtainService(CommonServices.GET_SESSION_LOCK);
        this.getSessionLocksService = serviceLocator.obtainService(CommonServices.GET_SESSION_LOCKS);
        this.sessionFetchContext = new SessionFetchContext(serviceLocator.obtainService(CommonServices.SESSION_FETCH), session.getAttributes().getMaximumMessageSize());
    }

    @Override
    public CompletableFuture<Registration> addSessionEventListener(ClientControl.SessionEventStream listener, ClientControl.SessionEventParameters parameters) {
        return this.sessionEventRegistration.registerSessionEventStream(Objects.requireNonNull(listener, "listener is null"), Objects.requireNonNull(parameters, "parameters is null")).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<Registration> setSessionPropertiesListener(ClientControl.SessionPropertiesStream listener, String ... requiredProperties) {
        return this.sessionEventRegistration.registerSessionPropertiesStream(Objects.requireNonNull(listener, "listener is null"), ImmutableSet.of(requiredProperties)).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<Map<String, String>> getSessionProperties(SessionId sessionId, Collection<String> requiredProperties) {
        return this.getSessionPropertiesService.sendCommand(new GetSessionPropertiesRequest(ClientControlImpl.toInternalSessionId(sessionId), ImmutableSet.from(Objects.requireNonNull(requiredProperties, "requiredProperties is null")))).thenApply(GetSessionPropertiesResult::getPropertiesChecked);
    }

    @Override
    public CompletableFuture<Map<String, String>> setSessionProperties(SessionId sessionId, Map<String, String> properties) {
        Objects.requireNonNull(properties, "properties is null");
        HashMap<String, String> overwriteProperties = new HashMap<String, String>();
        ArrayList<String> removeProperties = new ArrayList<String>();
        ClientControlImpl.extractOverwriteAndRemoveProperties(properties, overwriteProperties, removeProperties);
        CompletableFuture<SetSessionPropertiesResult> cf = this.setSessionPropertiesService.sendCommand(new SetSessionPropertiesRequest(ClientControlImpl.toInternalSessionId(sessionId), overwriteProperties, removeProperties));
        return cf.thenApply(SetSessionPropertiesResult::getAllProperties);
    }

    @Override
    public CompletableFuture<ClientControl.SessionFilterOperationResult> setSessionProperties(String filter, Map<String, String> properties) {
        Objects.requireNonNull(filter, "filter is null");
        Objects.requireNonNull(properties, "properties is null");
        HashMap<String, String> overwriteProperties = new HashMap<String, String>();
        ArrayList<String> removeProperties = new ArrayList<String>();
        ClientControlImpl.extractOverwriteAndRemoveProperties(properties, overwriteProperties, removeProperties);
        return ((CompletableFuture)this.setSessionFilterService.sendCommand(new SetSessionPropertiesFilterRequest(filter, overwriteProperties, removeProperties)).thenApply(CountOrParserErrors::getCountChecked)).thenApply(count -> () -> count);
    }

    private static void extractOverwriteAndRemoveProperties(Map<String, String> properties, Map<String, String> overwriteProperties, List<String> removeProperties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String value = entry.getValue();
            if (value == null) {
                removeProperties.add(entry.getKey());
                continue;
            }
            overwriteProperties.put(entry.getKey(), value);
        }
    }

    @Override
    public CompletableFuture<Registration> setQueueEventHandler(ClientControl.QueueEventStream handler) {
        return this.queueEventHandlerRegistration.registerQueueEventHandler(Objects.requireNonNull(handler, "handler is null")).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<?> close(SessionId sessionId) {
        return this.closeService.sendCommand(new CloseClientRequest(ClientControlImpl.toInternalSessionId(sessionId))).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<ClientControl.SessionFilterOperationResult> close(String filter) {
        return ((CompletableFuture)this.closeFilterService.sendCommand(Objects.requireNonNull(filter, "filter is null")).thenApply(CountOrParserErrors::getCountChecked)).thenApply(count -> () -> count);
    }

    @Override
    public CompletableFuture<?> setConflated(SessionId sessionId, boolean conflate) {
        return this.conflateService.sendCommand(new SetClientQueueConflationRequest(ClientControlImpl.toInternalSessionId(sessionId), conflate)).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<ClientControl.SessionFilterOperationResult> setConflated(String filter, boolean conflate) {
        return ((CompletableFuture)this.conflateFilterService.sendCommand(new SetClientQueueConflationFilterRequest(Objects.requireNonNull(filter, "filter is null"), conflate)).thenApply(CountOrParserErrors::getCountChecked)).thenApply(count -> () -> count);
    }

    private static InternalSessionId toInternalSessionId(SessionId sessionId) {
        return (InternalSessionId)Objects.requireNonNull(sessionId, "sessionId is null");
    }

    @Override
    public CompletableFuture<?> changeRoles(SessionId sessionId, Set<String> rolesToRemove, Set<String> rolesToAdd) throws IllegalArgumentException {
        ClientControlImpl.checkRolesSets(rolesToRemove, rolesToAdd);
        return this.changeRolesService.sendCommand(new ChangeAuthorisationRolesRequest(ClientControlImpl.toInternalSessionId(sessionId), rolesToRemove, rolesToAdd)).thenApply(Functions.identity());
    }

    @Override
    public CompletableFuture<Integer> changeRoles(String filter, Set<String> rolesToRemove, Set<String> rolesToAdd) throws IllegalArgumentException {
        Objects.requireNonNull(filter, "filter is null");
        ClientControlImpl.checkRolesSets(rolesToRemove, rolesToAdd);
        return this.changeRolesFilterService.sendCommand(new ChangeAuthorisationRolesFilterRequest(filter, rolesToRemove, rolesToAdd)).thenApply(CountOrParserErrors::getCountChecked);
    }

    private static void checkRolesSets(Set<String> rolesToRemove, Set<String> rolesToAdd) throws IllegalArgumentException {
        Objects.requireNonNull(rolesToRemove, "rolesToRemove is null");
        Objects.requireNonNull(rolesToAdd, "rolesToAdd is null");
        if (rolesToRemove.isEmpty() && rolesToAdd.isEmpty()) {
            throw new IllegalArgumentException("Both rolesToRemove and rolesToAdd sets are empty");
        }
        if (!Collections.disjoint(rolesToRemove, rolesToAdd)) {
            throw new IllegalArgumentException("Sets rolesToRemove and rolesToAdd contain same role(s)");
        }
    }

    @Override
    public InternalClientControl.SessionFetchRequest sessionFetchRequest() {
        return new SessionFetchRequestImpl(this.sessionFetchContext);
    }

    @Override
    public CompletableFuture<ClientControl.SessionLockDetails> getSessionLock(String lockName) {
        return this.getSessionLockService.sendCommand(Objects.requireNonNull(lockName, "lockName is null")).thenApply(GetSessionLockResult::getLockDetails);
    }

    @Override
    public CompletableFuture<Map<String, ClientControl.SessionLockDetails>> getSessionLocks() {
        return this.getSessionLocksService.sendCommand(null).thenApply(GetSessionLocksResult::getDetails);
    }
}

