/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.api.internal.connection;

import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.api.internal.connection.ServerDetailsFactory;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.comms.connection.ProxyConnector;
import com.pushtechnology.diffusion.configuration.LimitTimeouts;
import java.net.SocketAddress;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class ServerDetailsImpl
implements ServerDetails {
    public static final int MINIMUM_MESSAGE_SIZE = 8;
    private final SessionAttributes.Transport transport;
    private final boolean secure;
    private final String host;
    private final int port;
    private final String path;
    private int theInputBufferSize = -1;
    private int theOutputBufferSize = -1;
    private ProxyConnector theProxyConnector = null;
    private long theWriteTimeout = 2000L;
    private SSLContext theSSLContext;
    private SocketAddress theLocalSocketAddress = null;
    private long theConnectionTimeout = 2000L;
    private boolean isSSLHostVerificationDisabled = false;

    public ServerDetailsImpl(SessionAttributes.Transport transport, String host, int port, boolean secure, String path) {
        this.transport = transport;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.path = path;
    }

    @Override
    public int getInputBufferSize() {
        if (this.theInputBufferSize == -1) {
            return 131072;
        }
        return this.theInputBufferSize;
    }

    @Override
    public void setInputBufferSize(int inputBufferSize) {
        if (inputBufferSize >= 8) {
            this.theInputBufferSize = inputBufferSize;
        } else if (inputBufferSize < 0) {
            this.theInputBufferSize = -1;
        }
    }

    @Override
    public int getOutputBufferSize() {
        if (this.theOutputBufferSize < 0) {
            return 131072;
        }
        return this.theOutputBufferSize;
    }

    @Override
    public void setOutputBufferSize(int outputBufferSize) {
        if (outputBufferSize >= 8) {
            this.theOutputBufferSize = outputBufferSize;
        } else if (outputBufferSize < 0) {
            this.theOutputBufferSize = -1;
        }
    }

    @Override
    public long getWriteTimeout() {
        return this.theWriteTimeout;
    }

    @Override
    public void setWriteTimeout(long timeout) {
        this.theWriteTimeout = LimitTimeouts.limitTimeout("write timeout", timeout);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setProxyConnector(ProxyConnector proxyConnector) {
        this.theProxyConnector = proxyConnector;
    }

    @Override
    public ProxyConnector getProxyConnector() {
        return this.theProxyConnector;
    }

    @Override
    public SSLContext getSSLContext() throws NoSuchAlgorithmException {
        return this.theSSLContext == null ? SSLContext.getDefault() : this.theSSLContext;
    }

    @Override
    public void setSSLContext(SSLContext context) {
        this.theSSLContext = context;
    }

    @Override
    public void setConnectionTimeout(long timeout) {
        this.theConnectionTimeout = LimitTimeouts.limitTimeout("connection timeout", timeout);
    }

    @Override
    public long getConnectionTimeout() {
        return this.theConnectionTimeout;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.theLocalSocketAddress;
    }

    @Override
    public void setLocalSocketAddress(SocketAddress localSocketAddress) {
        this.theLocalSocketAddress = localSocketAddress;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public SessionAttributes.Transport getTransport() {
        return this.transport;
    }

    @Override
    public boolean isSecureConnection() {
        return this.secure;
    }

    @Override
    public boolean isSSLHostVerificationDisabled() {
        return this.isSSLHostVerificationDisabled;
    }

    @Override
    public void disableSSLHostVerification() {
        this.isSSLHostVerificationDisabled = true;
    }

    public String toString() {
        return ServerDetailsFactory.getURI(this.host, this.port, this.transport, this.secure, this.path);
    }
}

